/**
 * MachForm
 * 
 * © 2007–2025 Appnitro Software. All rights reserved.
 * 
 * This source code is proprietary and may not be copied, modified,
 * or distributed in any form without express written permission from Appnitro Software.
 * 
 * License information: https://www.machform.com/license-agreement/
 */

/** Functions **/

//automatically adjust the Y position of all dropuis
function adjust_dropui_positions(dropui_group){
	
	var form_border_width = parseInt($("#form_container").css("border-top-width"));
	var form_logo_height  = $("#form_header_preview").outerHeight();
	var form_margin		  = 20;
	
	var form_title_height 	   = $("#form_title_preview").outerHeight();
	var form_desc_text_height  = $("#form_desc_preview").outerHeight();
	
	var form_desc_block_height =  $("#form_theme_preview div.form_description").outerHeight(true);
	var field_title_height	   =  $("#li_1 label.description").height();
	
	var li_1_height = $("#li_1").outerHeight(true);
	var li_2_height = $("#li_2").outerHeight(true);
	var li_3_height = $("#li_3").outerHeight(true);
	var li_4_height = $("#li_4").outerHeight(true);
	
	var guidelines_height = $("#guide_2").outerHeight(true);
	
	var section_padding 	 = parseInt($("#li_4").css("padding-top"));
	var section_border_width = parseInt($("#li_4").css("border-top-width"));
	var section_title_height = $("#section_title_preview").height();
	var section_desc_height  = $("#section_desc_preview").height();
	
	if(dropui_group == 'logo'){
		var form_logo_dropui = form_border_width + form_logo_height - 23;
		$("#dropui-form-logo").css("top", form_logo_dropui + "px");
	}else if(dropui_group == 'backgrounds'){
		//form background
		var form_bg_dropui = form_border_width + form_logo_height + form_margin + form_title_height + form_desc_text_height - 18;
		$("#dropui-bg-form").css("top", form_bg_dropui + "px");
		
		//highlight background
		var highlight_bg_dropui = form_border_width + form_logo_height + form_margin + form_desc_block_height + li_1_height + li_2_height + 58;
		$("#dropui-bg-highlight").css("top", highlight_bg_dropui + "px");
		
		//field guidelines color
		var guidelines_bg_dropui = form_border_width + form_logo_height + form_margin + form_desc_block_height + li_1_height + guidelines_height - 27;
		$("#dropui-bg-guidelines").css("top", guidelines_bg_dropui + "px");
		
		//field color
		var field_bg_dropui = form_border_width + form_logo_height + form_margin + form_desc_block_height + li_1_height + li_2_height + li_3_height + li_4_height - 34;
		$("#dropui-bg-field").css("top", field_bg_dropui + "px");
	}else if(dropui_group == 'fonts'){
		//form title
		var form_title_dropui = form_border_width + form_logo_height + form_margin + form_title_height - 26;
		$("#dropui-typo-form-title").css("top", form_title_dropui + "px");
		
		//form description
		var form_desc_dropui = form_border_width + form_logo_height + form_margin + form_title_height + form_desc_text_height + 2;
		$("#dropui-typo-form-desc").css("top", form_desc_dropui + "px");
		
		//field title
		var field_title_dropui = form_border_width + form_logo_height + form_margin + form_desc_block_height + field_title_height - 19;
		$("#dropui-typo-field-title").css("top", field_title_dropui + "px");
		
		//field guidelines
		var guidelines_dropui = form_border_width + form_logo_height + form_margin + form_desc_block_height + li_1_height + guidelines_height - 27;
		$("#dropui-typo-guidelines").css("top", guidelines_dropui + "px");
		
		//section title
		var section_title_dropui = form_border_width + form_logo_height + form_margin + form_desc_block_height + li_1_height + li_2_height + section_border_width + section_title_height - 2;
		$("#dropui-typo-section-title").css("top", section_title_dropui + "px");
		
		//section desc
		var section_desc_dropui = form_border_width + form_logo_height + form_margin + form_desc_block_height + li_1_height + li_2_height + section_border_width + section_title_height + section_desc_height + 76;
		$("#dropui-typo-section-desc").css("top", section_desc_dropui + "px");
		
		//field text
		var field_text_dropui = form_border_width + form_logo_height + form_margin + form_desc_block_height + li_1_height + li_2_height + li_3_height + li_4_height - 34;
		$("#dropui-typo-field-text").css("top", field_text_dropui + "px");
	}else if(dropui_group == 'borders'){
		//field guidelines border
		var guidelines_border_dropui = form_border_width + form_logo_height + form_margin + form_desc_block_height + li_1_height + guidelines_height - 27;
		$("#dropui-border-guidelines").css("top", guidelines_border_dropui + "px");
		
		//section break border
		var section_border_dropui = form_border_width + form_logo_height + form_margin + form_desc_block_height + li_1_height + li_2_height + 68;
		$("#dropui-border-section").css("top", section_border_dropui + "px");
	}else if(dropui_group == 'shadows'){
		var form_shadow_dropui = $("#form_container").outerHeight() + 24;
		$("#dropui-form-shadow").css("top", form_shadow_dropui + "px");
	}else if(dropui_group == 'buttons'){
		var form_button_dropui = $("#form_container").outerHeight() - 51;
		$("#dropui-form-button").css("top", form_button_dropui + "px");
	}
}


//convert RGB to HEX color
function rgb2hex(rgb){
	if(rgb.charAt(0) == '#'){ //if this is already rgb code
		return rgb;
	}else{
		rgb = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);
		return "#" +
		  ("0" + parseInt(rgb[1],10).toString(16)).slice(-2) +
		  ("0" + parseInt(rgb[2],10).toString(16)).slice(-2) +
		  ("0" + parseInt(rgb[3],10).toString(16)).slice(-2);
	}
}

function ucfirst(string){
    return string.charAt(0).toUpperCase() + string.slice(1);
}

//Check if HTML5 uploader is supported by the browser
function is_support_html5_uploader(){
	if (window.File && window.FileList && window.Blob && (window.FileReader || window.FormData)) {
		return true;
	}else{
		return false;
	}
}

//apply all the values of the theme_properties into the form preview
//this should only being used to reload the built-in theme only, due to limited functionalities
//not all properties being loaded, such as the logo, shadows and buttons
function reload_theme(){
	var theme_properties  = $("#et_theme_preview").data("theme_properties");
	
	//Wallpaper
	if(theme_properties.wallpaper_bg_type == 'color'){
		$("#et_theme_preview").css("background-image","");
		$("#et_theme_preview").css("background-color",theme_properties.wallpaper_bg_color);
	}else if(theme_properties.wallpaper_bg_type == 'pattern'){
		$("#et_theme_preview").css("background-image","url('images/form_resources/" + theme_properties.wallpaper_bg_pattern + "')");
		$("#et_theme_preview").css("background-repeat","repeat");
	}else if(theme_properties.wallpaper_bg_type == 'custom'){
		$("#et_theme_preview").css("background-color","#ececec");
		$("#et_theme_preview").css("background-image","url('" + theme_properties.wallpaper_bg_custom + "')");
		$("#et_theme_preview").css("background-repeat","repeat");
	}
	
	//Header Background
	if(theme_properties.header_bg_type == 'color'){
		$("#form_header_preview").css("background-image","");
		$("#form_header_preview").css("background-color",theme_properties.header_bg_color);
	}else if(theme_properties.header_bg_type == 'pattern'){
		$("#form_header_preview").css("background-image","url('images/form_resources/" + theme_properties.header_bg_pattern + "')");
		$("#form_header_preview").css("background-repeat","repeat");
	}else if(theme_properties.header_bg_type == 'custom'){
		$("#form_header_preview").css("background-color","#ececec");
		$("#form_header_preview").css("background-image","url('" + theme_properties.header_bg_custom + "')");
		$("#form_header_preview").css("background-repeat","repeat");
	}
	
	//Form Background
	if(theme_properties.form_bg_type == 'color'){
		$("#form_container").css("background-image","");
		$("#form_container").css("background-color",theme_properties.form_bg_color);
	}else if(theme_properties.form_bg_type == 'pattern'){
		$("#form_container").css("background-image","url('images/form_resources/" + theme_properties.form_bg_pattern + "')");
		$("#form_container").css("background-repeat","repeat");
	}else if(theme_properties.form_bg_type == 'custom'){
		$("#form_container").css("background-color","#ececec");
		$("#form_container").css("background-image","url('" + theme_properties.form_bg_custom + "')");
		$("#form_container").css("background-repeat","repeat");
	}
	
	//Field Highlight
	if(theme_properties.highlight_bg_type == 'color'){
		$("#li_fields li.highlighted").css("background-image","");
		$("#li_fields li.highlighted").css("background-color",theme_properties.highlight_bg_color);
	}else if(theme_properties.highlight_bg_type == 'pattern'){
		$("#li_fields li.highlighted").css("background-image","url('images/form_resources/" + theme_properties.highlight_bg_pattern + "')");
		$("#li_fields li.highlighted").css("background-repeat","repeat");
	}else if(theme_properties.highlight_bg_type == 'custom'){
		$("#li_fields li.highlighted").css("background-color","#ececec");
		$("#li_fields li.highlighted").css("background-image","url('" + theme_properties.highlight_bg_custom + "')");
		$("#li_fields li.highlighted").css("background-repeat","repeat");
	}
	
	//Field Guidelines
	if(theme_properties.guidelines_bg_type == 'color'){
		$("#li_fields p.guidelines").css("background-image","");
		$("#li_fields p.guidelines").css("background-color",theme_properties.guidelines_bg_color);
	}else if(theme_properties.guidelines_bg_type == 'pattern'){
		$("#li_fields p.guidelines").css("background-image","url('images/form_resources/" + theme_properties.guidelines_bg_pattern + "')");
		$("#li_fields p.guidelines").css("background-repeat","repeat");
	}else if(theme_properties.guidelines_bg_type == 'custom'){
		$("#li_fields p.guidelines").css("background-color","#ececec");
		$("#li_fields p.guidelines").css("background-image","url('" + theme_properties.guidelines_bg_custom + "')");
		$("#li_fields p.guidelines").css("background-repeat","repeat");
	}
	
	//Field Background
	if(theme_properties.field_bg_type == 'color'){
		$("#form_theme_preview :input").not(".submit_button").css("background-image","");
		$("#form_theme_preview :input").not(".submit_button").css("background-color",theme_properties.field_bg_color);
	}else if(theme_properties.field_bg_type == 'pattern'){
		$("#form_theme_preview :input").not(".submit_button").css("background-image","url('images/form_resources/" + theme_properties.field_bg_pattern + "')");
		$("#form_theme_preview :input").not(".submit_button").css("background-repeat","repeat");
	}else if(theme_properties.field_bg_type == 'custom'){
		$("#form_theme_preview :input").not(".submit_button").css("background-color","#ececec");
		$("#form_theme_preview :input").not(".submit_button").css("background-image","url('" + theme_properties.field_bg_custom + "')");
		$("#form_theme_preview :input").not(".submit_button").css("background-repeat","repeat");
	}
	
	//Form Title
	$("#form_title_preview").css("font-family","'" + theme_properties.form_title_font_type + "'" + ",'Lucida Grande',Tahoma,Arial,sans-serif");
	$("#form_title_preview").css("font-weight",theme_properties.form_title_font_weight);
	$("#form_title_preview").css("font-style",theme_properties.form_title_font_style);
	$("#form_title_preview").css("font-size",theme_properties.form_title_font_size);
	$("#form_title_preview").css("color",theme_properties.form_title_font_color);
	
	//Form Description
	$("#form_desc_preview").css("font-family","'" + theme_properties.form_desc_font_type + "'" + ",'Lucida Grande',Tahoma,Arial,sans-serif");
	$("#form_desc_preview").css("font-weight",theme_properties.form_desc_font_weight);
	$("#form_desc_preview").css("font-style",theme_properties.form_desc_font_style);
	$("#form_desc_preview").css("font-size",theme_properties.form_desc_font_size);
	$("#form_desc_preview").css("color",theme_properties.form_desc_font_color);
	
	//Field Title
	$("#form_theme_preview label").css("font-family","'" + theme_properties.field_title_font_type + "'" + ",'Lucida Grande',Tahoma,Arial,sans-serif");
	$("#form_theme_preview label.description").css("font-weight",theme_properties.field_title_font_weight);
	$("#form_theme_preview label.description").css("font-style",theme_properties.field_title_font_style);
	$("#form_theme_preview label.description").css("font-size",theme_properties.field_title_font_size);
	$("#form_theme_preview label").css("color",theme_properties.field_title_font_color);
	
	//Field Guidelines
	$("#li_fields p.guidelines small").css("font-family","'" + theme_properties.guidelines_font_type + "'" + ",'Lucida Grande',Tahoma,Arial,sans-serif");
	$("#li_fields p.guidelines small").css("font-weight",theme_properties.guidelines_font_weight);
	$("#li_fields p.guidelines small").css("font-style",theme_properties.guidelines_font_style);
	$("#li_fields p.guidelines small").css("font-size",theme_properties.guidelines_font_size);
	$("#li_fields p.guidelines small").css("color",theme_properties.guidelines_font_color);
	
	//Section Title
	$("#section_title_preview").css("font-family","'" + theme_properties.section_title_font_type + "'" + ",'Lucida Grande',Tahoma,Arial,sans-serif");
	$("#section_title_preview").css("font-weight",theme_properties.section_title_font_weight);
	$("#section_title_preview").css("font-style",theme_properties.section_title_font_style);
	$("#section_title_preview").css("font-size",theme_properties.section_title_font_size);
	$("#section_title_preview").css("color",theme_properties.section_title_font_color);
	
	//Section Description
	$("#section_desc_preview").css("font-family","'" + theme_properties.section_desc_font_type + "'" + ",'Lucida Grande',Tahoma,Arial,sans-serif");
	$("#section_desc_preview").css("font-weight",theme_properties.section_desc_font_weight);
	$("#section_desc_preview").css("font-style",theme_properties.section_desc_font_style);
	$("#section_desc_preview").css("font-size",theme_properties.section_desc_font_size);
	$("#section_desc_preview").css("color",theme_properties.section_desc_font_color);
	
	//Field Text
	$("#form_theme_preview :input").not(".submit_button").css("font-family","'" + theme_properties.field_text_font_type + "'" + ",'Lucida Grande',Tahoma,Arial,sans-serif");
	$("#form_theme_preview :input").not(".submit_button").css("font-weight",theme_properties.field_text_font_weight);
	$("#form_theme_preview :input").not(".submit_button").css("font-style",theme_properties.field_text_font_style);
	$("#form_theme_preview :input").not(".submit_button").css("font-size",theme_properties.field_text_font_size);
	$("#form_theme_preview :input").not(".submit_button").css("color",theme_properties.field_text_font_color);
	
	//Form Border
	$("#form_container").css("border-width",theme_properties.border_form_width + "px");
	$("#form_container").css("border-style",theme_properties.border_form_style);
	$("#form_container").css("border-color",theme_properties.border_form_color);
	
	//Guidelines Border
	$("#guide_2").css("border-width",theme_properties.border_guidelines_width + "px");
	$("#guide_2").css("border-style",theme_properties.border_guidelines_style);
	$("#guide_2").css("border-color",theme_properties.border_guidelines_color);
	
	//Section Border
	$("#li_4").css("border-top-width",theme_properties.border_section_width + "px");
	$("#li_4").css("border-top-style",theme_properties.border_section_style);
	$("#li_4").css("border-top-color",theme_properties.border_section_color);
	
	
}


/** Event Handlers **/
$(function(){
	//the global variable which contain the whole theme properties
	var theme_properties  = $("#et_theme_preview").data("theme_properties");
	
    /***************************************************************************************************************/	
	/* 1. Attach Click event to the main tab bar												   				   */
	/***************************************************************************************************************/
	
	//assign click event on tab bar selection
	//display related properties for each category
	$("#et_theme_button_ul li").on('click',function(){
		var clicked_tab = $(this).attr("id");
		var prop_name;
		
		var current_tab = $("#et_theme_button_ul > li.current");
		$("#main_body div.dropui-circle").hide();
		
		current_tab.removeClass("current");
		
		if(current_tab.attr("id") != clicked_tab){
			$(this).addClass("current");
			
			if(clicked_tab == 'li_tab_logo'){
				prop_name = 'et-prop-logo';
				adjust_dropui_positions('logo');
			}else if(clicked_tab == 'li_tab_backgrounds'){
				prop_name = 'et-prop-bg';
				adjust_dropui_positions('backgrounds');
			}else if(clicked_tab == 'li_tab_fonts'){
				prop_name = 'et-prop-typo';
				adjust_dropui_positions('fonts');
			}else if(clicked_tab == 'li_tab_borders'){
				prop_name = 'et-prop-border';
				adjust_dropui_positions('borders');
			}else if(clicked_tab == 'li_tab_shadows'){
				prop_name = 'et-prop-shadow';
				adjust_dropui_positions('shadows');
			}else if(clicked_tab == 'li_tab_buttons'){
				prop_name = 'et-prop-button';
				adjust_dropui_positions('buttons');
			}
			
			
			
			$("#main_body div." + prop_name).fadeIn();
		}
	});
	
	//close permanent-dropui when the close button being clicked
	$("#et_theme_preview a.dropui-close").on('click',function(){
		
		$(this).parents('div.hovered').removeClass('hovered');
		$(this).parents('div.dropui-content').hide();
		
		return false;
	});
	
	
    /***************************************************************************************************************/	
	/* 2. Attach events to Form Logo															   				   */
	/***************************************************************************************************************/
	
	
	//assign click event for the radio button on the vertical tab bar
	//show/hide the selected tab based on the radio button clicked
	$("#et_ul_form_logo input[type=radio]").on('click',function(){
		$('#' + $("#et_ul_form_logo li.prop_selected input").attr('id') + '_tab').hide();
		$("#et_ul_form_logo li.prop_selected").removeClass('prop_selected');
		
		$(this).parent().addClass('prop_selected');
		$('#' + $(this).attr('id') + '_tab').fadeIn(); //display the tab content
		
		var selected_radio_id = $(this).attr('id');

		$("#et_form_logo_content").css("height","");
		
		if(selected_radio_id == 'et_form_logo_none'){ //'disable logo' radio selected
			//restore the logo height to the default 40px
			$("#form_logo_preview").animate({height: '40px'},{duration:200,queue:false, complete: function(){ adjust_dropui_positions('logo'); }});
			theme_properties.logo_type = 'disabled';
			
			//make sure to update the preview
			$("#form_logo_preview").css("background-image", "url('images/form_resources/nologo.png')");
		}else if(selected_radio_id == 'et_form_logo_default'){
			$("#form_logo_preview").animate({height: '40px'},{duration:200,queue:false, complete: function(){ adjust_dropui_positions('logo'); }});
			theme_properties.logo_type = 'default'; //default logo
			
			//make sure to update the preview
			var image_name = theme_properties.logo_default_image;
			$("#form_logo_preview").css("background-image", "url('images/form_resources/" + image_name + "')");
			$("#form_logo_preview").css("background-repeat","no-repeat");
			
		}else if(selected_radio_id == 'et_form_logo_custom'){
			theme_properties.logo_type = 'custom'; //custom logo
			
			$("#et_form_logo_content").css("height","100%");

			//make sure to update the preview
			$("#form_logo_preview").css("background-image", "url('"+ theme_properties.logo_custom_image  +"')");
			$("#form_logo_preview").css("background-repeat","no-repeat");
			$("#form_logo_preview").animate({height:  theme_properties.logo_custom_height + 'px'},{duration:200,queue:false, complete: function(){ adjust_dropui_positions('logo'); }});
		}
	});
	
	//assign change event to the default logo dropdown
	//change the logo based on selection
	$('#et_logo_default_dropdown').on('change', function() {
		var image_name = $(this).val();
		$("#form_logo_preview").css("background-image", "url('images/form_resources/" + image_name + "')");
		$("#form_logo_preview").css("background-repeat","no-repeat");
			
		theme_properties.logo_default_image = image_name;
	});
	
	//'apply custom logo' button clicked
	$("#et_your_logo_submit").on('click',function(){
		$("#form_logo_preview").css("background-image", "url('"+ $("#et_your_logo_url").val()  +"')");
		
		var logo_height = $("#et_your_logo_height").val();
		$("#form_logo_preview").animate({height: logo_height + 'px'},{duration:200,queue:false, complete: function(){ adjust_dropui_positions('logo'); }});
		
		theme_properties.logo_type = 'custom'; //custom logo type
		theme_properties.logo_custom_height = parseInt(logo_height);
		theme_properties.logo_custom_image  = $("#et_your_logo_url").val();
	});
	
	//display dropui permanently on click and load the properties
	$("#dropui-form-logo a.dropui-tab").on('click',function(){
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//unselect all tabs and hide all contents
		$("#et_ul_form_logo li.prop_selected").removeClass('prop_selected');
		$("#et_form_logo_content > div").hide();
			
		//populate the settings for custom logo and default logo
		$("#et_your_logo_url").val(theme_properties.logo_custom_image);
		$("#et_your_logo_height").val(theme_properties.logo_custom_height);
		$("#et_logo_default_dropdown").val(theme_properties.logo_default_image);
			
		//display the selected logo type tab
		if(theme_properties.logo_type == 'disabled'){ //logo disabled
			$("#et_form_logo_none").parent().addClass('prop_selected');
			$("#et_form_logo_none").prop("checked",true);
				
			$("#et_form_logo_none_tab").show();
		}else if(theme_properties.logo_type == 'default'){ //using default logo
			$("#et_form_logo_default").parent().addClass('prop_selected');
			$("#et_form_logo_default").prop("checked",true);
				
			$("#et_form_logo_default_tab").show();
		}else if(theme_properties.logo_type == 'custom'){ //using custom logo
			$("#et_form_logo_custom").parent().addClass('prop_selected');
			$("#et_form_logo_custom").prop("checked",true);

			$("#et_form_logo_content").css("height","100%");
				
			$("#et_form_logo_custom_tab").show();
		}
				
	});

	
    /***************************************************************************************************************/	
	/* 3. Attach events to Wallpaper											   				   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-bg-main a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-bg-main,#dropui-bg-header,#dropui-bg-form,#dropui-bg-highlight,#dropui-bg-guidelines,#dropui-bg-field").removeClass('hovered');
		$("#dropui-bg-main div.dropui-content,#dropui-bg-header div.dropui-content,#dropui-bg-form div.dropui-content," +
		  "#dropui-bg-highlight div.dropui-content,#dropui-bg-guidelines div.dropui-content,#dropui-bg-field div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//unselect all tabs and hide all contents
		$("#et_ul_form_wallpaper li.prop_selected").removeClass('prop_selected');
		$("#et_form_wallpaper_content > div").hide();
		
		//load all tab properties first
		$("#et_form_wallpaper_minicolor_box").css("background-image","");
		$("#et_form_wallpaper_minicolor_box").css("background-color",theme_properties.wallpaper_bg_color);
		
		$("#et_form_wallpaper_pattern_box").css("background-image","url('images/form_resources/" + theme_properties.wallpaper_bg_pattern + "')");
		$("#et_form_wallpaper_pattern_box").css("background-repeat","repeat");
		
		var pattern_number = $('#et_form_wallpaper_pattern_tab ul.et_pattern_picker > li[data-pattern="'+ theme_properties.wallpaper_bg_pattern +'"]').index() + 1;
		$("#et_form_wallpaper_pattern_number").text('#' + pattern_number);
		$("#et_form_wallpaper_pattern_tab ul li:eq("+ (pattern_number - 1) +")").addClass('picker_selected');
		
		$("#et_wallpaper_custom_bg").val(theme_properties.wallpaper_bg_custom);
		
		//display the selected tab
		if(theme_properties.wallpaper_bg_type == 'color'){
			if(theme_properties.wallpaper_bg_color == 'transparent'){
				$("#et_form_wallpaper_minicolor_box").css("background-image","url('images/icons/transparent.png')");
				$("#et_form_wallpaper_minicolor_box").css("background-repeat","repeat");
				
				$("#et_form_wallpaper_color_tab ul li:eq(0)").addClass('picker_selected');
			}else{
				$("#et_form_wallpaper_minicolor_input").miniColors('value', theme_properties.wallpaper_bg_color);
			}
			
			$("#et_form_wallpaper_color").prop("checked",true);
			$("#et_form_wallpaper_color").parent().addClass('prop_selected');
			$("#et_form_wallpaper_color_tab").show();
		}else if(theme_properties.wallpaper_bg_type == 'pattern'){
			
			$("#et_form_wallpaper_pattern").prop("checked",true);
			$("#et_form_wallpaper_pattern").parent().addClass('prop_selected');
			$("#et_form_wallpaper_pattern_tab").show();
		}else if(theme_properties.wallpaper_bg_type == 'custom'){

			$("#et_form_wallpaper_custom").prop("checked",true);
			$("#et_form_wallpaper_custom").parent().addClass('prop_selected');
			$("#et_form_wallpaper_custom_tab").show();
		}
		
	});
	
	//assign click event for the radio button on the vertical tab bar
	//show/hide the selected tab based on the radio button clicked
	$("#et_ul_form_wallpaper input[type=radio]").on('click',function(){
		$('#' + $("#et_ul_form_wallpaper li.prop_selected input").attr('id') + '_tab').hide();
		$("#et_ul_form_wallpaper li.prop_selected").removeClass('prop_selected');
		
		$(this).parent().addClass('prop_selected');
		$('#' + $(this).attr('id') + '_tab').fadeIn(); //display the tab content
		
		var selected_radio_id = $(this).attr('id');
			
		if(selected_radio_id == 'et_form_wallpaper_color'){
			theme_properties.wallpaper_bg_type = 'color';
			
			//update the preview
			if(theme_properties.wallpaper_bg_color == 'transparent'){
				$("#et_form_wallpaper_minicolor_input").miniColors('value','');
				
				$("#et_theme_preview").css("background-color",'transparent');
				$("#et_theme_preview").css("background-image","url('images/icons/transparent.png')");
				$("#et_theme_preview").css("background-repeat","repeat");
				
				$("#et_form_wallpaper_minicolor_box").css("background-image","url('images/icons/transparent.png')");
				$("#et_form_wallpaper_minicolor_box").css("background-repeat","repeat");
			}else{
				$("#et_theme_preview").css("background-image","");
				$("#et_form_wallpaper_minicolor_box").css("background-image","");
			
				$("#et_form_wallpaper_minicolor_box").css("background-color",theme_properties.wallpaper_bg_color);
				$("#et_theme_preview").css("background-color",theme_properties.wallpaper_bg_color);
			}
		}else if(selected_radio_id == 'et_form_wallpaper_pattern'){
			theme_properties.wallpaper_bg_type = 'pattern';
			
			$("#et_theme_preview").css("background-image","url('images/form_resources/" + theme_properties.wallpaper_bg_pattern + "')");
			$("#et_theme_preview").css("background-repeat","repeat");
			
			$("#et_form_wallpaper_pattern_box").css("background-image","url('images/form_resources/" + theme_properties.wallpaper_bg_pattern + "')");
			$("#et_form_wallpaper_pattern_box").css("background-repeat","repeat");
			
		}else if(selected_radio_id == 'et_form_wallpaper_custom'){
			theme_properties.wallpaper_bg_type = 'custom';
			
			$("#et_theme_preview").css("background-color","#ececec");
			$("#et_theme_preview").css("background-image","url('" + theme_properties.wallpaper_bg_custom + "')");
			$("#et_theme_preview").css("background-repeat","repeat");
		}
		
	});
	
	//attach events to color boxes
	$("#et_form_wallpaper_color_tab").on('click', 'li', function(e) {
		
		$("#et_form_wallpaper_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			$("#et_form_wallpaper_minicolor_input").miniColors('value','');
			
			$("#et_theme_preview").css("background-color",'transparent');
			$("#et_theme_preview").css("background-image","url('images/icons/transparent.png')");
			$("#et_theme_preview").css("background-repeat","repeat");
			
			$("#et_form_wallpaper_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_form_wallpaper_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.wallpaper_bg_color = 'transparent';
		}else{
			
			$("#et_theme_preview").css("background-image","");
			$("#et_form_wallpaper_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_form_wallpaper_minicolor_input").miniColors('value', hex_color);
			
			theme_properties.wallpaper_bg_color = hex_color;
		}
	});
	
	//attach events to pattern boxes
	$("#et_form_wallpaper_pattern_tab").on('click', 'li', function(e) {
		$("#et_form_wallpaper_pattern_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		$("#et_theme_preview").css("background-image",$(this).css("background-image"));
		$("#et_theme_preview").css("background-repeat","repeat");
		
		$("#et_form_wallpaper_pattern_box").css("background-image",$(this).css("background-image"));
		$("#et_form_wallpaper_pattern_box").css("background-repeat","repeat");
		$("#et_form_wallpaper_pattern_number").text('#' + ($(this).index() + 1));
		
		theme_properties.wallpaper_bg_pattern = $(this).data('pattern');
	});
	
	//attach change event to wallpaper minicolors
	$("#et_form_wallpaper_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#et_theme_preview").css("background-image","");
			$("#et_theme_preview").css("background-repeat","no-repeat");
			
			$("#et_form_wallpaper_minicolor_box").css("background-image","");
			$("#et_form_wallpaper_minicolor_box").css("background-repeat","no-repeat");
		
			$("#et_form_wallpaper_minicolor_box").css("background-color",hex);
			$("#et_theme_preview").css("background-color",hex);
			
			theme_properties.wallpaper_bg_color = hex;
		}
		
	});
	
	//attach event to 'apply custom pattern' button
	$("#et_wallpaper_custom_bg_submit").on('click',function(){
		$("#et_theme_preview").css("background-color","#ececec");
		$("#et_theme_preview").css("background-image","url('" + $("#et_wallpaper_custom_bg").val() + "')");
		$("#et_theme_preview").css("background-repeat","repeat");
		
		theme_properties.wallpaper_bg_custom = $("#et_wallpaper_custom_bg").val();
	});
	
	/***************************************************************************************************************/	
	/* 4. Attach events to Header Background											  		 				   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-bg-header a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-bg-main,#dropui-bg-header,#dropui-bg-form,#dropui-bg-highlight,#dropui-bg-guidelines,#dropui-bg-field").removeClass('hovered');
		$("#dropui-bg-main div.dropui-content,#dropui-bg-header div.dropui-content,#dropui-bg-form div.dropui-content," +
		  "#dropui-bg-highlight div.dropui-content,#dropui-bg-guidelines div.dropui-content,#dropui-bg-field div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//unselect all tabs and hide all contents
		$("#et_ul_form_headerbg li.prop_selected").removeClass('prop_selected');
		$("#et_form_headerbg_content > div").hide();
		
		//load all tab properties first
		$("#et_form_headerbg_minicolor_box").css("background-image","");
		$("#et_form_headerbg_minicolor_box").css("background-color",theme_properties.header_bg_color);
		
		$("#et_form_headerbg_pattern_box").css("background-image","url('images/form_resources/" + theme_properties.header_bg_pattern + "')");
		$("#et_form_headerbg_pattern_box").css("background-repeat","repeat");
		
		var pattern_number = $('#et_form_headerbg_pattern_tab ul.et_pattern_picker > li[data-pattern="'+ theme_properties.header_bg_pattern +'"]').index() + 1;
		$("#et_form_headerbg_pattern_number").text('#' + pattern_number);
		$("#et_form_headerbg_pattern_tab ul li:eq("+ (pattern_number - 1) +")").addClass('picker_selected');
		
		$("#et_headerbg_custom_bg").val(theme_properties.header_bg_custom);
		
		//display the selected tab
		if(theme_properties.header_bg_type == 'color'){	
			if(theme_properties.header_bg_color == 'transparent'){
				$("#et_form_headerbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
				$("#et_form_headerbg_minicolor_box").css("background-repeat","repeat");
				
				$("#et_form_headerbg_color_tab ul li:eq(0)").addClass('picker_selected');
			}else{
				$("#et_form_headerbg_minicolor_input").miniColors('value', theme_properties.header_bg_color);
			}
			
			$("#et_form_headerbg_color").prop("checked",true);
			$("#et_form_headerbg_color").parent().addClass('prop_selected');
			$("#et_form_headerbg_color_tab").show();
		}else if(theme_properties.header_bg_type == 'pattern'){
			
			$("#et_form_headerbg_pattern").prop("checked",true);
			$("#et_form_headerbg_pattern").parent().addClass('prop_selected');
			$("#et_form_headerbg_pattern_tab").show();
		}else if(theme_properties.header_bg_type == 'custom'){

			$("#et_form_headerbg_custom").prop("checked",true);
			$("#et_form_headerbg_custom").parent().addClass('prop_selected');
			$("#et_form_headerbg_custom_tab").show();
		}
		
	});
	
	//assign click event for the radio button on the vertical tab bar
	//show/hide the selected tab based on the radio button clicked
	$("#et_ul_form_headerbg input[type=radio]").on('click',function(){
		$('#' + $("#et_ul_form_headerbg li.prop_selected input").attr('id') + '_tab').hide();
		$("#et_ul_form_headerbg li.prop_selected").removeClass('prop_selected');
		
		$(this).parent().addClass('prop_selected');
		$('#' + $(this).attr('id') + '_tab').fadeIn(); //display the tab content
		
		var selected_radio_id = $(this).attr('id');
			
		if(selected_radio_id == 'et_form_headerbg_color'){
			theme_properties.header_bg_type = 'color';
			
			//update the preview
			$("#form_header_preview").css("background-image","");
			
			if(theme_properties.header_bg_color == 'transparent'){
				$("#et_form_headerbg_minicolor_input").miniColors('value','');
				
				$("#et_form_headerbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
				$("#et_form_headerbg_minicolor_box").css("background-repeat","repeat");
			}else{
				
				$("#et_form_headerbg_minicolor_box").css("background-image","");
				$("#et_form_headerbg_minicolor_box").css("background-color",theme_properties.header_bg_color);
			}
			
			$("#form_header_preview").css("background-color",theme_properties.header_bg_color);
		}else if(selected_radio_id == 'et_form_headerbg_pattern'){
			theme_properties.header_bg_type = 'pattern';
			
			$("#form_header_preview").css("background-image","url('images/form_resources/" + theme_properties.header_bg_pattern + "')");
			$("#form_header_preview").css("background-repeat","repeat");
			
			$("#et_form_headerbg_pattern_box").css("background-image","url('images/form_resources/" + theme_properties.header_bg_pattern + "')");
			$("#et_form_headerbg_pattern_box").css("background-repeat","repeat");
			
		}else if(selected_radio_id == 'et_form_headerbg_custom'){
			theme_properties.header_bg_type = 'custom';
			
			$("#form_header_preview").css("background-color","#ececec");
			$("#form_header_preview").css("background-image","url('" + theme_properties.header_bg_custom + "')");
			$("#form_header_preview").css("background-repeat","repeat");
		}
		
	});
	
	//attach events to color boxes
	$("#et_form_headerbg_color_tab").on('click', 'li', function(e) {
		
		$("#et_form_headerbg_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			$("#et_form_headerbg_minicolor_input").miniColors('value','');
			
			$("#form_header_preview").css("background-color",'transparent');
			
			$("#et_form_headerbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_form_headerbg_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.header_bg_color = 'transparent';
		}else{
			
			$("#form_header_preview").css("background-image","");
			$("#et_form_headerbg_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_form_headerbg_minicolor_input").miniColors('value', hex_color);
			
			theme_properties.header_bg_color = hex_color;
		}
	});
	
	//attach events to pattern boxes
	$("#et_form_headerbg_pattern_tab").on('click', 'li', function(e) {
		$("#et_form_headerbg_pattern_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		$("#form_header_preview").css("background-image",$(this).css("background-image"));
		$("#form_header_preview").css("background-repeat","repeat");
		
		$("#et_form_headerbg_pattern_box").css("background-image",$(this).css("background-image"));
		$("#et_form_headerbg_pattern_box").css("background-repeat","repeat");
		$("#et_form_headerbg_pattern_number").text('#' + ($(this).index() + 1));
		
		theme_properties.header_bg_pattern = $(this).data('pattern');
	});
	
	//attach change event to header background minicolors
	$("#et_form_headerbg_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#form_header_preview").css("background-image","");
			$("#form_header_preview").css("background-repeat","no-repeat");
			
			$("#et_form_headerbg_minicolor_box").css("background-image","");
			$("#et_form_headerbg_minicolor_box").css("background-repeat","no-repeat");
		
			$("#et_form_headerbg_minicolor_box").css("background-color",hex);
			$("#form_header_preview").css("background-color",hex);
			
			theme_properties.header_bg_color = hex;
		}
		
	});
	
	//attach event to 'apply custom pattern' button
	$("#et_headerbg_custom_bg_submit").on('click',function(){
		$("#form_header_preview").css("background-color","#ececec");
		$("#form_header_preview").css("background-image","url('" + $("#et_headerbg_custom_bg").val() + "')");
		$("#form_header_preview").css("background-repeat","repeat");
		
		theme_properties.header_bg_custom = $("#et_headerbg_custom_bg").val();
	});
	
	/***************************************************************************************************************/	
	/* 5. Attach events to Form Background												  		 				   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-bg-form a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-bg-main,#dropui-bg-header,#dropui-bg-form,#dropui-bg-highlight,#dropui-bg-guidelines,#dropui-bg-field").removeClass('hovered');
		$("#dropui-bg-main div.dropui-content,#dropui-bg-header div.dropui-content,#dropui-bg-form div.dropui-content," +
		  "#dropui-bg-highlight div.dropui-content,#dropui-bg-guidelines div.dropui-content,#dropui-bg-field div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//unselect all tabs and hide all contents
		$("#et_ul_form_formbg li.prop_selected").removeClass('prop_selected');
		$("#et_form_formbg_content > div").hide();
		
		//load all tab properties first
		$("#et_form_formbg_minicolor_box").css("background-image","");
		$("#et_form_formbg_minicolor_box").css("background-color",theme_properties.form_bg_color);
		
		$("#et_form_formbg_pattern_box").css("background-image","url('images/form_resources/" + theme_properties.form_bg_pattern + "')");
		$("#et_form_formbg_pattern_box").css("background-repeat","repeat");
		
		var pattern_number = $('#et_form_formbg_pattern_tab ul.et_pattern_picker > li[data-pattern="'+ theme_properties.form_bg_pattern +'"]').index() + 1;
		$("#et_form_formbg_pattern_number").text('#' + pattern_number);
		$("#et_form_formbg_pattern_tab ul li:eq("+ (pattern_number - 1) +")").addClass('picker_selected');
		
		$("#et_formbg_custom_bg").val(theme_properties.form_bg_custom);
		
		//display the selected tab
		if(theme_properties.form_bg_type == 'color'){	
			if(theme_properties.form_bg_color == 'transparent'){
				$("#et_form_formbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
				$("#et_form_formbg_minicolor_box").css("background-repeat","repeat");
				
				$("#et_form_formbg_color_tab ul li:eq(0)").addClass('picker_selected');
			}else{
				$("#et_form_formbg_minicolor_input").miniColors('value', theme_properties.form_bg_color);
			}
			
			$("#et_form_formbg_color").prop("checked",true);
			$("#et_form_formbg_color").parent().addClass('prop_selected');
			$("#et_form_formbg_color_tab").show();
		}else if(theme_properties.form_bg_type == 'pattern'){
			
			$("#et_form_formbg_pattern").prop("checked",true);
			$("#et_form_formbg_pattern").parent().addClass('prop_selected');
			$("#et_form_formbg_pattern_tab").show();
		}else if(theme_properties.form_bg_type == 'custom'){

			$("#et_form_formbg_custom").prop("checked",true);
			$("#et_form_formbg_custom").parent().addClass('prop_selected');
			$("#et_form_formbg_custom_tab").show();
		}
		
	});
	
	//assign click event for the radio button on the vertical tab bar
	//show/hide the selected tab based on the radio button clicked
	$("#et_ul_form_formbg input[type=radio]").on('click',function(){
		$('#' + $("#et_ul_form_formbg li.prop_selected input").attr('id') + '_tab').hide();
		$("#et_ul_form_formbg li.prop_selected").removeClass('prop_selected');
		
		$(this).parent().addClass('prop_selected');
		$('#' + $(this).attr('id') + '_tab').fadeIn(); //display the tab content
		
		var selected_radio_id = $(this).attr('id');
			
		if(selected_radio_id == 'et_form_formbg_color'){
			theme_properties.form_bg_type = 'color';
			
			//update the preview
			$("#form_container").css("background-image","");
			
			if(theme_properties.form_bg_color == 'transparent'){
				$("#et_form_formbg_minicolor_input").miniColors('value','');
				
				$("#et_form_formbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
				$("#et_form_formbg_minicolor_box").css("background-repeat","repeat");
			}else{
				
				$("#et_form_formbg_minicolor_box").css("background-image","");
				$("#et_form_formbg_minicolor_box").css("background-color",theme_properties.form_bg_color);
			}
			
			$("#form_container").css("background-color",theme_properties.form_bg_color);
		}else if(selected_radio_id == 'et_form_formbg_pattern'){
			theme_properties.form_bg_type = 'pattern';
			
			$("#form_container").css("background-image","url('images/form_resources/" + theme_properties.form_bg_pattern + "')");
			$("#form_container").css("background-repeat","repeat");
			
			$("#et_form_formbg_pattern_box").css("background-image","url('images/form_resources/" + theme_properties.form_bg_pattern + "')");
			$("#et_form_formbg_pattern_box").css("background-repeat","repeat");
			
		}else if(selected_radio_id == 'et_form_formbg_custom'){
			theme_properties.form_bg_type = 'custom';
			
			$("#form_container").css("background-color","#ececec");
			$("#form_container").css("background-image","url('" + theme_properties.form_bg_custom + "')");
			$("#form_container").css("background-repeat","repeat");
		}
		
	});
	
	//attach events to color boxes
	$("#et_form_formbg_color_tab").on('click', 'li', function(e) {
		
		$("#et_form_formbg_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			$("#et_form_formbg_minicolor_input").miniColors('value','');
			
			$("#form_container").css("background-color",'transparent');
			
			$("#et_form_formbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_form_formbg_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.form_bg_color = 'transparent';
		}else{
			
			$("#form_container").css("background-image","");
			$("#et_form_formbg_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_form_formbg_minicolor_input").miniColors('value', hex_color);
			
			theme_properties.form_bg_color = hex_color;
		}
	});
	
	//attach events to pattern boxes
	$("#et_form_formbg_pattern_tab").on('click', 'li', function(e) {
		$("#et_form_formbg_pattern_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		$("#form_container").css("background-image",$(this).css("background-image"));
		$("#form_container").css("background-repeat","repeat");
		
		$("#et_form_formbg_pattern_box").css("background-image",$(this).css("background-image"));
		$("#et_form_formbg_pattern_box").css("background-repeat","repeat");
		$("#et_form_formbg_pattern_number").text('#' + ($(this).index() + 1));
		
		theme_properties.form_bg_pattern = $(this).data('pattern');
	});
	
	//attach change event to header background minicolors
	$("#et_form_formbg_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#form_container").css("background-image","");
			$("#form_container").css("background-repeat","no-repeat");
			
			$("#et_form_formbg_minicolor_box").css("background-image","");
			$("#et_form_formbg_minicolor_box").css("background-repeat","no-repeat");
		
			$("#et_form_formbg_minicolor_box").css("background-color",hex);
			$("#form_container").css("background-color",hex);
			
			theme_properties.form_bg_color = hex;
		}
		
	});
	
	//attach event to 'apply custom pattern' button
	$("#et_formbg_custom_bg_submit").on('click',function(){
		$("#form_container").css("background-color","#ececec");
		$("#form_container").css("background-image","url('" + $("#et_formbg_custom_bg").val() + "')");
		$("#form_container").css("background-repeat","repeat");
		
		theme_properties.form_bg_custom = $("#et_formbg_custom_bg").val();
	});
	
	/***************************************************************************************************************/	
	/* 6. Attach events to Field Highlight												  		 				   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-bg-highlight a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-bg-main,#dropui-bg-header,#dropui-bg-form,#dropui-bg-highlight,#dropui-bg-guidelines,#dropui-bg-field").removeClass('hovered');
		$("#dropui-bg-main div.dropui-content,#dropui-bg-header div.dropui-content,#dropui-bg-form div.dropui-content," +
		  "#dropui-bg-highlight div.dropui-content,#dropui-bg-guidelines div.dropui-content,#dropui-bg-field div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//unselect all tabs and hide all contents
		$("#et_ul_form_highlightbg li.prop_selected").removeClass('prop_selected');
		$("#et_form_highlightbg_content > div").hide();
		
		//load all tab properties first
		$("#et_form_highlightbg_minicolor_box").css("background-image","");
		$("#et_form_highlightbg_minicolor_box").css("background-color",theme_properties.highlight_bg_color);
		
		$("#et_form_highlightbg_pattern_box").css("background-image","url('images/form_resources/" + theme_properties.highlight_bg_pattern + "')");
		$("#et_form_highlightbg_pattern_box").css("background-repeat","repeat");
		
		var pattern_number = $('#et_form_highlightbg_pattern_tab ul.et_pattern_picker > li[data-pattern="'+ theme_properties.highlight_bg_pattern +'"]').index() + 1;
		$("#et_form_highlightbg_pattern_number").text('#' + pattern_number);
		$("#et_form_highlightbg_pattern_tab ul li:eq("+ (pattern_number - 1) +")").addClass('picker_selected');
		
		$("#et_highlightbg_custom_bg").val(theme_properties.highlight_bg_custom);
		
		//display the selected tab
		if(theme_properties.highlight_bg_type == 'color'){	
			if(theme_properties.highlight_bg_color == 'transparent'){
				$("#et_form_highlightbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
				$("#et_form_highlightbg_minicolor_box").css("background-repeat","repeat");
				
				$("#et_form_highlightbg_color_tab ul li:eq(0)").addClass('picker_selected');
			}else{
				$("#et_form_highlightbg_minicolor_input").miniColors('value', theme_properties.highlight_bg_color);
			}
			
			$("#et_form_highlightbg_color").prop("checked",true);
			$("#et_form_highlightbg_color").parent().addClass('prop_selected');
			$("#et_form_highlightbg_color_tab").show();
		}else if(theme_properties.highlight_bg_type == 'pattern'){
			
			$("#et_form_highlightbg_pattern").prop("checked",true);
			$("#et_form_highlightbg_pattern").parent().addClass('prop_selected');
			$("#et_form_highlightbg_pattern_tab").show();
		}else if(theme_properties.highlight_bg_type == 'custom'){

			$("#et_form_highlightbg_custom").prop("checked",true);
			$("#et_form_highlightbg_custom").parent().addClass('prop_selected');
			$("#et_form_highlightbg_custom_tab").show();
		}
		
	});
	
	//assign click event for the radio button on the vertical tab bar
	//show/hide the selected tab based on the radio button clicked
	$("#et_ul_form_highlightbg input[type=radio]").on('click',function(){
		$('#' + $("#et_ul_form_highlightbg li.prop_selected input").attr('id') + '_tab').hide();
		$("#et_ul_form_highlightbg li.prop_selected").removeClass('prop_selected');
		
		$(this).parent().addClass('prop_selected');
		$('#' + $(this).attr('id') + '_tab').fadeIn(); //display the tab content
		
		var selected_radio_id = $(this).attr('id');
			
		if(selected_radio_id == 'et_form_highlightbg_color'){
			theme_properties.highlight_bg_type = 'color';
			
			//update the preview
			$("#li_fields li.highlighted").css("background-image","");
			
			if(theme_properties.highlight_bg_color == 'transparent'){
				$("#et_form_highlightbg_minicolor_input").miniColors('value','');
				
				$("#et_form_highlightbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
				$("#et_form_highlightbg_minicolor_box").css("background-repeat","repeat");
			}else{
				
				$("#et_form_highlightbg_minicolor_box").css("background-image","");
				$("#et_form_highlightbg_minicolor_box").css("background-color",theme_properties.highlight_bg_color);
			}
			
			$("#li_fields li.highlighted").css("background-color",theme_properties.highlight_bg_color);
		}else if(selected_radio_id == 'et_form_highlightbg_pattern'){
			theme_properties.highlight_bg_type = 'pattern';
			
			$("#li_fields li.highlighted").css("background-image","url('images/form_resources/" + theme_properties.highlight_bg_pattern + "')");
			$("#li_fields li.highlighted").css("background-repeat","repeat");
			
			$("#et_form_highlightbg_pattern_box").css("background-image","url('images/form_resources/" + theme_properties.highlight_bg_pattern + "')");
			$("#et_form_highlightbg_pattern_box").css("background-repeat","repeat");
			
		}else if(selected_radio_id == 'et_form_highlightbg_custom'){
			theme_properties.highlight_bg_type = 'custom';
			
			$("#li_fields li.highlighted").css("background-color","#ececec");
			$("#li_fields li.highlighted").css("background-image","url('" + theme_properties.highlight_bg_custom + "')");
			$("#li_fields li.highlighted").css("background-repeat","repeat");
		}
		
	});
	
	//attach events to color boxes
	$("#et_form_highlightbg_color_tab").on('click', 'li', function(e) {
		
		$("#et_form_highlightbg_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			$("#et_form_highlightbg_minicolor_input").miniColors('value','');
			
			$("#li_fields li.highlighted").css("background-color",'transparent');
			
			$("#et_form_highlightbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_form_highlightbg_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.highlight_bg_color = 'transparent';
		}else{
			
			$("#li_fields li.highlighted").css("background-image","");
			$("#et_form_highlightbg_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_form_highlightbg_minicolor_input").miniColors('value', hex_color);
			
			theme_properties.highlight_bg_color = hex_color;
		}
	});
	
	//attach events to pattern boxes
	$("#et_form_highlightbg_pattern_tab").on('click', 'li', function(e) {
		$("#et_form_highlightbg_pattern_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		$("#li_fields li.highlighted").css("background-image",$(this).css("background-image"));
		$("#li_fields li.highlighted").css("background-repeat","repeat");
		
		$("#et_form_highlightbg_pattern_box").css("background-image",$(this).css("background-image"));
		$("#et_form_highlightbg_pattern_box").css("background-repeat","repeat");
		$("#et_form_highlightbg_pattern_number").text('#' + ($(this).index() + 1));
		
		theme_properties.highlight_bg_pattern = $(this).data('pattern');
	});
	
	//attach change event to header background minicolors
	$("#et_form_highlightbg_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#li_fields li.highlighted").css("background-image","");
			$("#li_fields li.highlighted").css("background-repeat","no-repeat");
			
			$("#et_form_highlightbg_minicolor_box").css("background-image","");
			$("#et_form_highlightbg_minicolor_box").css("background-repeat","no-repeat");
		
			$("#et_form_highlightbg_minicolor_box").css("background-color",hex);
			$("#li_fields li.highlighted").css("background-color",hex);
			
			theme_properties.highlight_bg_color = hex;
		}
		
	});
	
	//attach event to 'apply custom pattern' button
	$("#et_highlightbg_custom_bg_submit").on('click',function(){
		$("#li_fields li.highlighted").css("background-color","#ececec");
		$("#li_fields li.highlighted").css("background-image","url('" + $("#et_highlightbg_custom_bg").val() + "')");
		$("#li_fields li.highlighted").css("background-repeat","repeat");
		
		theme_properties.highlight_bg_custom = $("#et_highlightbg_custom_bg").val();
	});
	
	/***************************************************************************************************************/	
	/* 7. Attach events to Field Guidelines Background												  		 	   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-bg-guidelines a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-bg-main,#dropui-bg-header,#dropui-bg-form,#dropui-bg-highlight,#dropui-bg-guidelines,#dropui-bg-field").removeClass('hovered');
		$("#dropui-bg-main div.dropui-content,#dropui-bg-header div.dropui-content,#dropui-bg-form div.dropui-content," +
		  "#dropui-bg-highlight div.dropui-content,#dropui-bg-guidelines div.dropui-content,#dropui-bg-field div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//unselect all tabs and hide all contents
		$("#et_ul_form_guidelinesbg li.prop_selected").removeClass('prop_selected');
		$("#et_form_guidelinesbg_content > div").hide();
		
		//load all tab properties first
		$("#et_form_guidelinesbg_minicolor_box").css("background-image","");
		$("#et_form_guidelinesbg_minicolor_box").css("background-color",theme_properties.guidelines_bg_color);
		
		$("#et_form_guidelinesbg_pattern_box").css("background-image","url('images/form_resources/" + theme_properties.guidelines_bg_pattern + "')");
		$("#et_form_guidelinesbg_pattern_box").css("background-repeat","repeat");
		
		var pattern_number = $('#et_form_guidelinesbg_pattern_tab ul.et_pattern_picker > li[data-pattern="'+ theme_properties.guidelines_bg_pattern +'"]').index() + 1;
		$("#et_form_guidelinesbg_pattern_number").text('#' + pattern_number);
		$("#et_form_guidelinesbg_pattern_tab ul li:eq("+ (pattern_number - 1) +")").addClass('picker_selected');
		
		$("#et_guidelinesbg_custom_bg").val(theme_properties.guidelines_bg_custom);
		
		//display the selected tab
		if(theme_properties.guidelines_bg_type == 'color'){	
			if(theme_properties.guidelines_bg_color == 'transparent'){
				$("#et_form_guidelinesbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
				$("#et_form_guidelinesbg_minicolor_box").css("background-repeat","repeat");
				
				$("#et_form_guidelinesbg_color_tab ul li:eq(0)").addClass('picker_selected');
			}else{
				$("#et_form_guidelinesbg_minicolor_input").miniColors('value', theme_properties.guidelines_bg_color);
			}
			
			$("#et_form_guidelinesbg_color").prop("checked",true);
			$("#et_form_guidelinesbg_color").parent().addClass('prop_selected');
			$("#et_form_guidelinesbg_color_tab").show();
		}else if(theme_properties.guidelines_bg_type == 'pattern'){
			
			$("#et_form_guidelinesbg_pattern").prop("checked",true);
			$("#et_form_guidelinesbg_pattern").parent().addClass('prop_selected');
			$("#et_form_guidelinesbg_pattern_tab").show();
		}else if(theme_properties.guidelines_bg_type == 'custom'){

			$("#et_form_guidelinesbg_custom").prop("checked",true);
			$("#et_form_guidelinesbg_custom").parent().addClass('prop_selected');
			$("#et_form_guidelinesbg_custom_tab").show();
		}
		
	});
	
	//assign click event for the radio button on the vertical tab bar
	//show/hide the selected tab based on the radio button clicked
	$("#et_ul_form_guidelinesbg input[type=radio]").on('click',function(){
		$('#' + $("#et_ul_form_guidelinesbg li.prop_selected input").attr('id') + '_tab').hide();
		$("#et_ul_form_guidelinesbg li.prop_selected").removeClass('prop_selected');
		
		$(this).parent().addClass('prop_selected');
		$('#' + $(this).attr('id') + '_tab').fadeIn(); //display the tab content
		
		var selected_radio_id = $(this).attr('id');
			
		if(selected_radio_id == 'et_form_guidelinesbg_color'){
			theme_properties.guidelines_bg_type = 'color';
			
			//update the preview
			$("#li_fields p.guidelines").css("background-image","");
			
			if(theme_properties.guidelines_bg_color == 'transparent'){
				$("#et_form_guidelinesbg_minicolor_input").miniColors('value','');
				
				$("#et_form_guidelinesbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
				$("#et_form_guidelinesbg_minicolor_box").css("background-repeat","repeat");
			}else{
				
				$("#et_form_guidelinesbg_minicolor_box").css("background-image","");
				$("#et_form_guidelinesbg_minicolor_box").css("background-color",theme_properties.guidelines_bg_color);
			}
			
			$("#li_fields p.guidelines").css("background-color",theme_properties.guidelines_bg_color);
		}else if(selected_radio_id == 'et_form_guidelinesbg_pattern'){
			theme_properties.guidelines_bg_type = 'pattern';
			
			$("#li_fields p.guidelines").css("background-image","url('images/form_resources/" + theme_properties.guidelines_bg_pattern + "')");
			$("#li_fields p.guidelines").css("background-repeat","repeat");
			
			$("#et_form_guidelinesbg_pattern_box").css("background-image","url('images/form_resources/" + theme_properties.guidelines_bg_pattern + "')");
			$("#et_form_guidelinesbg_pattern_box").css("background-repeat","repeat");
			
		}else if(selected_radio_id == 'et_form_guidelinesbg_custom'){
			theme_properties.guidelines_bg_type = 'custom';
			
			$("#li_fields p.guidelines").css("background-color","#ececec");
			$("#li_fields p.guidelines").css("background-image","url('" + theme_properties.guidelines_bg_custom + "')");
			$("#li_fields p.guidelines").css("background-repeat","repeat");
		}
		
	});
	
	//attach events to color boxes
	$("#et_form_guidelinesbg_color_tab").on('click', 'li', function(e) {
		
		$("#et_form_guidelinesbg_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			$("#et_form_guidelinesbg_minicolor_input").miniColors('value','');
			
			$("#li_fields p.guidelines").css("background-color",'transparent');
			
			$("#et_form_guidelinesbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_form_guidelinesbg_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.guidelines_bg_color = 'transparent';
		}else{
			
			$("#li_fields p.guidelines").css("background-image","");
			$("#et_form_guidelinesbg_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_form_guidelinesbg_minicolor_input").miniColors('value', hex_color);
			
			theme_properties.guidelines_bg_color = hex_color;
		}
	});
	
	//attach events to pattern boxes
	$("#et_form_guidelinesbg_pattern_tab").on('click', 'li', function(e) {
		$("#et_form_guidelinesbg_pattern_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		$("#li_fields p.guidelines").css("background-image",$(this).css("background-image"));
		$("#li_fields p.guidelines").css("background-repeat","repeat");
		
		$("#et_form_guidelinesbg_pattern_box").css("background-image",$(this).css("background-image"));
		$("#et_form_guidelinesbg_pattern_box").css("background-repeat","repeat");
		$("#et_form_guidelinesbg_pattern_number").text('#' + ($(this).index() + 1));
		
		theme_properties.guidelines_bg_pattern = $(this).data('pattern');
	});
	
	//attach change event to header background minicolors
	$("#et_form_guidelinesbg_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#li_fields p.guidelines").css("background-image","");
			$("#li_fields p.guidelines").css("background-repeat","no-repeat");
			
			$("#et_form_guidelinesbg_minicolor_box").css("background-image","");
			$("#et_form_guidelinesbg_minicolor_box").css("background-repeat","no-repeat");
		
			$("#et_form_guidelinesbg_minicolor_box").css("background-color",hex);
			$("#li_fields p.guidelines").css("background-color",hex);
			
			theme_properties.guidelines_bg_color = hex;
		}
		
	});
	
	//attach event to 'apply custom pattern' button
	$("#et_guidelinesbg_custom_bg_submit").on('click',function(){
		$("#li_fields p.guidelines").css("background-color","#ececec");
		$("#li_fields p.guidelines").css("background-image","url('" + $("#et_guidelinesbg_custom_bg").val() + "')");
		$("#li_fields p.guidelines").css("background-repeat","repeat");
		
		theme_properties.guidelines_bg_custom = $("#et_guidelinesbg_custom_bg").val();
	});
	
	/***************************************************************************************************************/	
	/* 8. Attach events to Field Background												  		 	   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-bg-field a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-bg-main,#dropui-bg-header,#dropui-bg-form,#dropui-bg-highlight,#dropui-bg-guidelines,#dropui-bg-field").removeClass('hovered');
		$("#dropui-bg-main div.dropui-content,#dropui-bg-header div.dropui-content,#dropui-bg-form div.dropui-content," +
		  "#dropui-bg-highlight div.dropui-content,#dropui-bg-guidelines div.dropui-content,#dropui-bg-field div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//unselect all tabs and hide all contents
		$("#et_ul_form_fieldbg li.prop_selected").removeClass('prop_selected');
		$("#et_form_fieldbg_content > div").hide();
		
		//load all tab properties first
		$("#et_form_fieldbg_minicolor_box").css("background-image","");
		$("#et_form_fieldbg_minicolor_box").css("background-color",theme_properties.field_bg_color);
		
		$("#et_form_fieldbg_pattern_box").css("background-image","url('images/form_resources/" + theme_properties.field_bg_pattern + "')");
		$("#et_form_fieldbg_pattern_box").css("background-repeat","repeat");
		
		var pattern_number = $('#et_form_fieldbg_pattern_tab ul.et_pattern_picker > li[data-pattern="'+ theme_properties.field_bg_pattern +'"]').index() + 1;
		$("#et_form_fieldbg_pattern_number").text('#' + pattern_number);
		$("#et_form_fieldbg_pattern_tab ul li:eq("+ (pattern_number - 1) +")").addClass('picker_selected');
		
		$("#et_fieldbg_custom_bg").val(theme_properties.field_bg_custom);
		
		//display the selected tab
		if(theme_properties.field_bg_type == 'color'){	
			
			if(theme_properties.field_bg_color == 'transparent'){
				$("#et_form_fieldbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
				$("#et_form_fieldbg_minicolor_box").css("background-repeat","repeat");
				
				$("#et_form_fieldbg_color_tab ul li:eq(0)").addClass('picker_selected');
			}else{
				$("#et_form_fieldbg_minicolor_input").miniColors('value', theme_properties.field_bg_color);
			}
			
			$("#form_theme_preview :input").not(".submit_button").css("background-repeat","repeat-x");
			
			$("#et_form_fieldbg_color").prop("checked",true);
			$("#et_form_fieldbg_color").parent().addClass('prop_selected');
			$("#et_form_fieldbg_color_tab").show();
		}else if(theme_properties.field_bg_type == 'pattern'){
			
			$("#et_form_fieldbg_pattern").prop("checked",true);
			$("#et_form_fieldbg_pattern").parent().addClass('prop_selected');
			$("#et_form_fieldbg_pattern_tab").show();
		}else if(theme_properties.field_bg_type == 'custom'){

			$("#et_form_fieldbg_custom").prop("checked",true);
			$("#et_form_fieldbg_custom").parent().addClass('prop_selected');
			$("#et_form_fieldbg_custom_tab").show();
		}
		
	});
	
	//assign click event for the radio button on the vertical tab bar
	//show/hide the selected tab based on the radio button clicked
	$("#et_ul_form_fieldbg input[type=radio]").on('click',function(){
		$('#' + $("#et_ul_form_fieldbg li.prop_selected input").attr('id') + '_tab').hide();
		$("#et_ul_form_fieldbg li.prop_selected").removeClass('prop_selected');
		
		$(this).parent().addClass('prop_selected');
		$('#' + $(this).attr('id') + '_tab').fadeIn(); //display the tab content
		
		var selected_radio_id = $(this).attr('id');
			
		if(selected_radio_id == 'et_form_fieldbg_color'){
			theme_properties.field_bg_type = 'color';
			
			//update the preview
			if(theme_properties.field_bg_color == 'transparent'){
				$("#et_form_fieldbg_minicolor_input").miniColors('value','');
				
				$("#et_form_fieldbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
				$("#et_form_fieldbg_minicolor_box").css("background-repeat","repeat");
			}else{
				
				$("#et_form_fieldbg_minicolor_box").css("background-image","");
				$("#et_form_fieldbg_minicolor_box").css("background-color",theme_properties.field_bg_color);
			}
			
			$("#form_theme_preview :input").not(".submit_button").css("background-image","");
			$("#form_theme_preview :input").not(".submit_button").css("background-repeat","repeat-x");
			
			$("#form_theme_preview :input").not(".submit_button").css("background-color",theme_properties.field_bg_color);
		}else if(selected_radio_id == 'et_form_fieldbg_pattern'){
			theme_properties.field_bg_type = 'pattern';
			
			$("#form_theme_preview :input").not(".submit_button").css("background-image","url('images/form_resources/" + theme_properties.field_bg_pattern + "')");
			$("#form_theme_preview :input").not(".submit_button").css("background-repeat","repeat");
			
			$("#et_form_fieldbg_pattern_box").css("background-image","url('images/form_resources/" + theme_properties.field_bg_pattern + "')");
			$("#et_form_fieldbg_pattern_box").css("background-repeat","repeat");
			
		}else if(selected_radio_id == 'et_form_fieldbg_custom'){
			theme_properties.field_bg_type = 'custom';
			
			$("#form_theme_preview :input").not(".submit_button").css("background-color","#ececec");
			$("#form_theme_preview :input").not(".submit_button").css("background-image","url('" + theme_properties.field_bg_custom + "')");
			$("#form_theme_preview :input").not(".submit_button").css("background-repeat","repeat");
		}
		
	});
	
	//attach events to color boxes
	$("#et_form_fieldbg_color_tab").on('click', 'li', function(e) {
		
		$("#et_form_fieldbg_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			$("#et_form_fieldbg_minicolor_input").miniColors('value','');
			
			$("#form_theme_preview :input").not(".submit_button").css("background-color",'transparent');
			
			$("#et_form_fieldbg_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_form_fieldbg_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.field_bg_color = 'transparent';
		}else{
			
			$("#et_form_fieldbg_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_form_fieldbg_minicolor_input").miniColors('value', hex_color);
			
			$("#form_theme_preview :input").not(".submit_button").css("background-image","");
			$("#form_theme_preview :input").not(".submit_button").css("background-repeat","repeat-x");
			
			theme_properties.field_bg_color = hex_color;
		}
	});
	
	//attach events to pattern boxes
	$("#et_form_fieldbg_pattern_tab").on('click', 'li', function(e) {
		$("#et_form_fieldbg_pattern_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		$("#form_theme_preview :input").not(".submit_button").css("background-image",$(this).css("background-image"));
		$("#form_theme_preview :input").not(".submit_button").css("background-repeat","repeat");
		
		$("#et_form_fieldbg_pattern_box").css("background-image",$(this).css("background-image"));
		$("#et_form_fieldbg_pattern_box").css("background-repeat","repeat");
		$("#et_form_fieldbg_pattern_number").text('#' + ($(this).index() + 1));
		
		theme_properties.field_bg_pattern = $(this).data('pattern');
	});
	
	//attach change event to field background minicolors
	$("#et_form_fieldbg_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#form_theme_preview :input").not(".submit_button").css("background-image","");
			$("#form_theme_preview :input").not(".submit_button").css("background-repeat","no-repeat");
			
			$("#et_form_fieldbg_minicolor_box").css("background-image","");
			$("#et_form_fieldbg_minicolor_box").css("background-repeat","no-repeat");
		
			$("#et_form_fieldbg_minicolor_box").css("background-color",hex);
			$("#form_theme_preview :input").not(".submit_button").css("background-color",hex);
			
			theme_properties.field_bg_color = hex;
		}
		
	});
	
	//attach event to 'apply custom pattern' button
	$("#et_fieldbg_custom_bg_submit").on('click',function(){
		$("#form_theme_preview :input").not(".submit_button").css("background-color","#ececec");
		$("#form_theme_preview :input").not(".submit_button").css("background-image","url('" + $("#et_fieldbg_custom_bg").val() + "')");
		$("#form_theme_preview :input").not(".submit_button").css("background-repeat","repeat");
		
		theme_properties.field_bg_custom = $("#et_fieldbg_custom_bg").val();
	});
	
	
	
	/***************************************************************************************************************/	
	/* 8. Attach event to "show more" list on font picker, this affect the whole dropui which has font picker	   */
	/***************************************************************************************************************/
	$("ul.et_font_picker li.li_show_more").on('click',function(){
		
		//show loading progress bar
		$("li.li_show_more").children('span').text('Loading');
		$("li.li_show_more").children('img').attr('src','images/loader_small_grey.gif');
		
		//do the ajax call to get more font list
		axios.post('get_font_list.php', {
			start_id: $("#header").data('last_font_id') + 1,
			list_length: 20
		})
		.then(function (response) {
			if(response.data.status == 'ok'){
				var new_font_markup = $(response.data.markup);
				
				$("li.li_show_more").before(new_font_markup);
				
				$("li.li_show_more").children('span').text('Show More Fonts');
				$("li.li_show_more").children('img').attr('src','images/icons/arrow_down.png');
				
				var font_styles_array = response.data.font_styles;
				
				$.each(font_styles_array,function(fontslug,value){
				  $("#header").data("font_" + fontslug,value);
				});
				$("#header").data('last_font_id', response.data.last_font_id);
				
				$("head").append(response.data.font_css_markup);
				
				if(response.data.list_end == true){
				   $("li.li_show_more").remove();
				}
			}else{
				//unknown error, response json improperly formatted
				$("li.li_show_more").children('span').text('Show More Fonts');
				$("li.li_show_more").children('img').attr('src','images/icons/arrow_down.png');

				Swal.fire({
					width: '30%',
					position: 'center',
					icon: 'error',
					title: 'Error. Unable to complete the task.',
					html: response.data,
					showConfirmButton: false,
					showCancelButton: true,
					cancelButtonText: 'Close',
					allowOutsideClick: true
				});
			}
		})
		.catch(function (error) {
			//unknown error, response json improperly formatted
			$("li.li_show_more").children('span').text('Show More Fonts');
			$("li.li_show_more").children('img').attr('src','images/icons/arrow_down.png');

			Swal.fire({
				width: '30%',
				position: 'center',
				icon: 'error',
				title: 'Error. Unable to complete the task.',
				html: error,
				showConfirmButton: false,
				showCancelButton: true,
				cancelButtonText: 'Close',
				allowOutsideClick: true
			});
		});
	});
	
	/***************************************************************************************************************/	
	/* 9. Attach events to Form Title																  		 	   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-typo-form-title a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-typo-form-title,#dropui-typo-form-desc,#dropui-typo-field-title,#dropui-typo-guidelines,#dropui-typo-section-title,#dropui-typo-section-desc,#dropui-typo-field-text").removeClass('hovered');
		$("#dropui-typo-form-title div.dropui-content,#dropui-typo-form-desc div.dropui-content,#dropui-typo-field-title div.dropui-content," +
		  "#dropui-typo-guidelines div.dropui-content,#dropui-typo-section-title div.dropui-content,#dropui-typo-section-desc div.dropui-content,#dropui-typo-field-text div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//when the first time being displayed, the font picker is being displayed
		//make sure to select the default font in this case
		if(theme_properties.form_title_font_type == '' || theme_properties.form_title_font_type == 'Lucida Grande'){
			$("#et_li_typo_form_title_font_tab li:eq(0)").addClass('font_selected');
		}
		
		//make sure to update the font preview box
		$("#et_form_title_font_preview_box").css("font-family",theme_properties.form_title_font_type);
		$("#et_form_title_font_preview_name").text(theme_properties.form_title_font_type);
		
		$("#et_typo_form_title_minicolor_input").miniColors('value', theme_properties.form_title_font_color);
	});
	
	//attach event to form title font minicolors
	$("#et_typo_form_title_minicolor_input").miniColors({
		change: function(hex, rgb) {
			
			$("#form_title_preview").css("color",hex);
			$("#et_typo_form_title_minicolor_box").css("background-color",hex);
			
			theme_properties.form_title_font_color = hex;
	
		}
		
	});
	
	//attach events to color boxes
	$("#et_li_typo_form_title_color_tab").on('click', 'li', function(e) {
		
		$("#et_li_typo_form_title_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			
			$("#et_typo_form_title_minicolor_input").miniColors('value','');
			
			$("#form_title_preview").css("color","transparent");
			
			$("#et_typo_form_title_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_typo_form_title_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.form_title_font_color = 'transparent';
		}else{
			
			$("#et_typo_form_title_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			
			$("#et_typo_form_title_minicolor_input").miniColors('value', hex_color);
		}
	});
	
	//attach event to the font tab bar
	$("#et_ul_typo_form_title").on('click', 'li', function(e) {
		$('#' + $("#et_ul_typo_form_title li.tab_selected").attr('id') + '_tab').hide();
		$("#et_ul_typo_form_title li.tab_selected").removeClass('tab_selected');
		
		$(this).addClass('tab_selected');
		
		//resize the tab container based on selection
		var selected_tab_id = $(this).attr('id');
		
		if(selected_tab_id == 'et_li_typo_form_title_style'){ //shrink to smaller size (font style)
			$("#et_typo_form_title_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-form-title div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			//populate the font variants radio button for the selected font type
			var font_slug = theme_properties.form_title_font_type.replace(/ /g,'').toLowerCase();
			var font_variants = $("#header").data("font_" + font_slug);
			
			//if the font doesn't have variants being set, assume it's a system font and only have 3 variants (normal, italic, bold)
			if(font_variants == null){
				font_variants = {"400":"Normal","400-italic":"Italic","700":"Bold"};
			}
			
			var li_markup = '';
			$.each(font_variants,function(font_variant_numeric,font_variant_label){
				li_markup += '<li><input type="radio" name="et_typo_form_title_style_radio" id="et_typo_form_title_style_radio'+ font_variant_numeric +'" value="'+ font_variant_numeric + '" /> <label for="et_typo_form_title_style_radio'+ font_variant_numeric +'">'+ font_variant_label +'</label></li>';
			});
			
			$("#et_ul_typo_form_title_style > li").not('.dummy_li').remove();
			$("#et_ul_typo_form_title_style").append(li_markup);
			
			//select the radio button
			if(theme_properties.form_title_font_weight == 0){
				theme_properties.form_title_font_weight = 400; //set to normal as the default
			}
			
			var selected_font_style = theme_properties.form_title_font_weight;
			if(theme_properties.form_title_font_style == 'italic'){
				selected_font_style = selected_font_style + "-italic";
			}
			
			$("#et_ul_typo_form_title_style input[value='"+ selected_font_style +"']").prop("checked",true);
			
		}else if(selected_tab_id == 'et_li_typo_form_title_size'){ //shrink to smaller size (font size)
			$("#et_typo_form_title_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-form-title div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			if(theme_properties.form_title_font_size == ''){
				theme_properties.form_title_font_size = '160%'; //the default size for form_title
			}
			
			//select the box
			$("#et_typo_form_title_size_pickerbox li[data-fsize='"+ theme_properties.form_title_font_size +"']").addClass('box_selected');
			
		}else if(selected_tab_id == 'et_li_typo_form_title_color'){ //shrink to smaller size (font color)
			$("#et_typo_form_title_content").animate({'width': '305px'},{duration:200,queue:false});
			$("#dropui-typo-form-title div.dropui-content").animate({'width': '360px'},{duration:200,queue:false });
			
		}else{
			$("#et_typo_form_title_content").animate({'width': '450px'},{duration:200,queue:false});
			$("#dropui-typo-form-title div.dropui-content").animate({'width': '507px'},{duration:200,queue:false});
		}
		
		$('#' + selected_tab_id + '_tab').fadeIn(); //display the tab content
		
	});
	
	//attach event to the font type picker list
	$("#et_li_typo_form_title_font_tab").on('click','li:not(.li_show_more)',function(e){
		//update the preview within the form
		$("#form_title_preview").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#form_title_preview").css("font-weight","400");
		$("#form_title_preview").css("font-style","normal");
		
		//highlight selected font list
		$(this).siblings().removeClass('font_selected');
		$(this).addClass('font_selected');
		
		//update the font preview box
		$("#et_form_title_font_preview_box").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#et_form_title_font_preview_name").text($(this).children('div.font_picker_preview').text());
		
		//save the data into the theme properties
		theme_properties.form_title_font_type = $(this).find('div.font_name').text();
		
		//reset the font variants to normal
		theme_properties.form_title_font_weight = 400;
		theme_properties.form_title_font_style  = 'normal';
	});
	
	//attach event to the font styles (italic, bold, normal, etc)
	$("#et_ul_typo_form_title_style").on('click',"input[type='radio']",function(e){
		var option_values = $(this).val().split('-');
		
		$("#form_title_preview").css("font-weight",option_values[0]);
		theme_properties.form_title_font_weight = parseInt(option_values[0]);
		
		if(option_values[1] == 'italic'){
			$("#form_title_preview").css("font-style","italic");
			theme_properties.form_title_font_style = 'italic';
		}else{
			$("#form_title_preview").css("font-style","normal");
			theme_properties.form_title_font_style = 'normal';
		}
	});
	
	//attach event to the font size boxes
	$("#et_typo_form_title_size_pickerbox").on('click', 'li', function(e){
		$("#form_title_preview").css("font-size",$(this).data('fsize'));
		$(this).siblings().removeClass('box_selected');
		$(this).addClass('box_selected');
		
		theme_properties.form_title_font_size = $(this).data('fsize');
		
		adjust_dropui_positions('fonts');
	});
	
	/***************************************************************************************************************/	
	/* 9. Attach events to Form Description															  		 	   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-typo-form-desc a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-typo-form-title,#dropui-typo-form-desc,#dropui-typo-field-title,#dropui-typo-guidelines,#dropui-typo-section-title,#dropui-typo-section-desc,#dropui-typo-field-text").removeClass('hovered');
		$("#dropui-typo-form-title div.dropui-content,#dropui-typo-form-desc div.dropui-content,#dropui-typo-field-title div.dropui-content," +
		  "#dropui-typo-guidelines div.dropui-content,#dropui-typo-section-title div.dropui-content,#dropui-typo-section-desc div.dropui-content,#dropui-typo-field-text div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//when the first time being displayed, the font picker is being displayed
		//make sure to select the default font in this case
		if(theme_properties.form_desc_font_type == '' || theme_properties.form_desc_font_type == 'Lucida Grande'){
			$("#et_li_typo_form_desc_font_tab li:eq(0)").addClass('font_selected');
		}
		
		//make sure to update the font preview box
		$("#et_form_desc_font_preview_box").css("font-family",theme_properties.form_desc_font_type);
		$("#et_form_desc_font_preview_name").text(theme_properties.form_desc_font_type);
		
		$("#et_typo_form_desc_minicolor_input").miniColors('value', theme_properties.form_desc_font_color);
	});
	
	//attach event to form title font minicolors
	$("#et_typo_form_desc_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#form_desc_preview").css("color",hex);
			$("#et_typo_form_desc_minicolor_box").css("background-color",hex);
			
			theme_properties.form_desc_font_color = hex;
	
		}
		
	});
	
	//attach events to color boxes
	$("#et_li_typo_form_desc_color_tab").on('click', 'li', function(e) {
		
		$("#et_li_typo_form_desc_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			
			$("#et_typo_form_desc_minicolor_input").miniColors('value','');
			
			$("#form_desc_preview").css("color","transparent");
			
			$("#et_typo_form_desc_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_typo_form_desc_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.form_desc_font_color = 'transparent';
		}else{
			
			$("#et_typo_form_desc_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_typo_form_desc_minicolor_input").miniColors('value', hex_color);
		}
	});
	
	//attach event to the font tab bar
	$("#et_ul_typo_form_desc").on('click', 'li', function(e) {
		$('#' + $("#et_ul_typo_form_desc li.tab_selected").attr('id') + '_tab').hide();
		$("#et_ul_typo_form_desc li.tab_selected").removeClass('tab_selected');
		
		$(this).addClass('tab_selected');
		
		//resize the tab container based on selection
		var selected_tab_id = $(this).attr('id');
		
		if(selected_tab_id == 'et_li_typo_form_desc_style'){ //shrink to smaller size (font style)
			$("#et_typo_form_desc_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-form-desc div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			//populate the font variants radio button for the selected font type
			var font_slug = theme_properties.form_desc_font_type.replace(/ /g,'').toLowerCase();
			var font_variants = $("#header").data("font_" + font_slug);
			
			//if the font doesn't have variants being set, assume it's a system font and only have 3 variants (normal, italic, bold)
			if(font_variants == null){
				font_variants = {"400":"Normal","400-italic":"Italic","700":"Bold"};
			}
			
			var li_markup = '';
			$.each(font_variants,function(font_variant_numeric,font_variant_label){
				li_markup += '<li><input type="radio" name="et_typo_form_desc_style_radio" id="et_typo_form_desc_style_radio'+ font_variant_numeric +'" value="'+ font_variant_numeric + '" /> <label for="et_typo_form_desc_style_radio'+ font_variant_numeric +'">'+ font_variant_label +'</label></li>';
			});
			
			$("#et_ul_typo_form_desc_style > li").not('.dummy_li').remove();
			$("#et_ul_typo_form_desc_style").append(li_markup);
			
			//select the radio button
			if(theme_properties.form_desc_font_weight == 0){
				theme_properties.form_desc_font_weight = 400; //set to normal as the default
			}
			
			var selected_font_style = theme_properties.form_desc_font_weight;
			if(theme_properties.form_desc_font_style == 'italic'){
				selected_font_style = selected_font_style + "-italic";
			}
			
			$("#et_ul_typo_form_desc_style input[value='"+ selected_font_style +"']").prop("checked",true);
			
		}else if(selected_tab_id == 'et_li_typo_form_desc_size'){ //shrink to smaller size (font size)
			$("#et_typo_form_desc_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-form-desc div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			if(theme_properties.form_desc_font_size == ''){
				theme_properties.form_desc_font_size = '95%'; //the default size for form_desc
			}
			
			//select the box
			$("#et_typo_form_desc_size_pickerbox li[data-fsize='"+ theme_properties.form_desc_font_size +"']").addClass('box_selected');
			
		}else if(selected_tab_id == 'et_li_typo_form_desc_color'){ //shrink to smaller size (font color)
			$("#et_typo_form_desc_content").animate({'width': '305px'},{duration:200,queue:false});
			$("#dropui-typo-form-desc div.dropui-content").animate({'width': '360px'},{duration:200,queue:false });
			
		}else{
			$("#et_typo_form_desc_content").animate({'width': '450px'},{duration:200,queue:false});
			$("#dropui-typo-form-desc div.dropui-content").animate({'width': '507px'},{duration:200,queue:false});
		}
		
		$('#' + selected_tab_id + '_tab').fadeIn(); //display the tab content
		
	});
	
	//attach event to the font type picker list
	$("#et_li_typo_form_desc_font_tab").on('click','li:not(.li_show_more)',function(e){
		//update the preview within the form
		$("#form_desc_preview").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#form_desc_preview").css("font-weight","400");
		$("#form_desc_preview").css("font-style","normal");
		
		//highlight selected font list
		$(this).siblings().removeClass('font_selected');
		$(this).addClass('font_selected');
		
		//update the font preview box
		$("#et_form_desc_font_preview_box").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#et_form_desc_font_preview_name").text($(this).children('div.font_picker_preview').text());
		
		//save the data into the theme properties
		theme_properties.form_desc_font_type = $(this).find('div.font_name').text();
		
		//reset the font variants to normal
		theme_properties.form_desc_font_weight = 400;
		theme_properties.form_desc_font_style  = 'normal';
	});
	
	//attach event to the font styles (italic, bold, normal, etc)
	$("#et_ul_typo_form_desc_style").on('click',"input[type='radio']",function(e){
		var option_values = $(this).val().split('-');
		
		$("#form_desc_preview").css("font-weight",option_values[0]);
		theme_properties.form_desc_font_weight = parseInt(option_values[0]);
		
		if(option_values[1] == 'italic'){
			$("#form_desc_preview").css("font-style","italic");
			theme_properties.form_desc_font_style = 'italic';
		}else{
			$("#form_desc_preview").css("font-style","normal");
			theme_properties.form_desc_font_style = 'normal';
		}
	});
	
	//attach event to the font size boxes
	$("#et_typo_form_desc_size_pickerbox").on('click', 'li', function(e){
		$("#form_desc_preview").css("font-size",$(this).data('fsize'));
		$(this).siblings().removeClass('box_selected');
		$(this).addClass('box_selected');
		
		theme_properties.form_desc_font_size = $(this).data('fsize');
		
		adjust_dropui_positions('fonts');
	});
	
	/***************************************************************************************************************/	
	/* 10. Attach events to Field Title																  		 	   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-typo-field-title a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-typo-form-title,#dropui-typo-form-desc,#dropui-typo-field-title,#dropui-typo-guidelines,#dropui-typo-section-title,#dropui-typo-section-desc,#dropui-typo-field-text").removeClass('hovered');
		$("#dropui-typo-form-title div.dropui-content,#dropui-typo-form-desc div.dropui-content,#dropui-typo-field-title div.dropui-content," +
		  "#dropui-typo-guidelines div.dropui-content,#dropui-typo-section-title div.dropui-content,#dropui-typo-section-desc div.dropui-content,#dropui-typo-field-text div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//when the first time being displayed, the font picker is being displayed
		//make sure to select the default font in this case
		if(theme_properties.field_title_font_type == '' || theme_properties.field_title_font_type == 'Lucida Grande'){
			$("#et_li_typo_field_title_font_tab li:eq(0)").addClass('font_selected');
		}
		
		//make sure to update the font preview box
		$("#et_field_title_font_preview_box").css("font-family",theme_properties.field_title_font_type);
		$("#et_field_title_font_preview_name").text(theme_properties.field_title_font_type);
		
		$("#et_typo_field_title_minicolor_input").miniColors('value', theme_properties.field_title_font_color);
	});
	
	//attach event to form title font minicolors
	$("#et_typo_field_title_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#form_theme_preview label").css("color",hex);
			$("#et_typo_field_title_minicolor_box").css("background-color",hex);
			
			theme_properties.field_title_font_color = hex;
	
		}
		
	});
	
	//attach events to color boxes
	$("#et_li_typo_field_title_color_tab").on('click', 'li', function(e) {
		
		$("#et_li_typo_field_title_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			
			$("#et_typo_field_title_minicolor_input").miniColors('value','');
			
			$("#form_theme_preview label").css("color","transparent");
			
			$("#et_typo_field_title_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_typo_field_title_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.field_title_font_color = 'transparent';
		}else{
			
			$("#et_typo_field_title_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_typo_field_title_minicolor_input").miniColors('value', hex_color);
		}
	});
	
	//attach event to the font tab bar
	$("#et_ul_typo_field_title").on('click', 'li', function(e) {
		$('#' + $("#et_ul_typo_field_title li.tab_selected").attr('id') + '_tab').hide();
		$("#et_ul_typo_field_title li.tab_selected").removeClass('tab_selected');
		
		$(this).addClass('tab_selected');
		
		//resize the tab container based on selection
		var selected_tab_id = $(this).attr('id');
		
		if(selected_tab_id == 'et_li_typo_field_title_style'){ //shrink to smaller size (font style)
			$("#et_typo_field_title_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-field-title div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			//populate the font variants radio button for the selected font type
			var font_slug = theme_properties.field_title_font_type.replace(/ /g,'').toLowerCase();
			var font_variants = $("#header").data("font_" + font_slug);
			
			//if the font doesn't have variants being set, assume it's a system font and only have 3 variants (normal, italic, bold)
			if(font_variants == null){
				font_variants = {"400":"Normal","400-italic":"Italic","700":"Bold"};
			}
			
			var li_markup = '';
			$.each(font_variants,function(font_variant_numeric,font_variant_label){
				li_markup += '<li><input type="radio" name="et_typo_field_title_style_radio" id="et_typo_field_title_style_radio'+ font_variant_numeric +'" value="'+ font_variant_numeric + '" /> <label for="et_typo_field_title_style_radio'+ font_variant_numeric +'">'+ font_variant_label +'</label></li>';
			});
			
			$("#et_ul_typo_field_title_style > li").not('.dummy_li').remove();
			$("#et_ul_typo_field_title_style").append(li_markup);
			
			//select the radio button
			if(theme_properties.field_title_font_weight == 0){
				theme_properties.field_title_font_weight = 400; //set to normal as the default
			}
			
			var selected_font_style = theme_properties.field_title_font_weight;
			if(theme_properties.field_title_font_style == 'italic'){
				selected_font_style = selected_font_style + "-italic";
			}
			
			$("#et_ul_typo_field_title_style input[value='"+ selected_font_style +"']").prop("checked",true);
			
		}else if(selected_tab_id == 'et_li_typo_field_title_size'){ //shrink to smaller size (font size)
			$("#et_typo_field_title_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-field-title div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			if(theme_properties.field_title_font_size == ''){
				theme_properties.field_title_font_size = '95%'; //the default size for field_title
			}
			
			//select the box
			$("#et_typo_field_title_size_pickerbox li[data-fsize='"+ theme_properties.field_title_font_size +"']").addClass('box_selected');
			
		}else if(selected_tab_id == 'et_li_typo_field_title_color'){ //shrink to smaller size (font color)
			$("#et_typo_field_title_content").animate({'width': '305px'},{duration:200,queue:false});
			$("#dropui-typo-field-title div.dropui-content").animate({'width': '360px'},{duration:200,queue:false });
			
		}else{
			$("#et_typo_field_title_content").animate({'width': '450px'},{duration:200,queue:false});
			$("#dropui-typo-field-title div.dropui-content").animate({'width': '507px'},{duration:200,queue:false});
		}
		
		$('#' + selected_tab_id + '_tab').fadeIn(); //display the tab content
		
	});
	
	//attach event to the font type picker list
	$("#et_li_typo_field_title_font_tab").on('click','li:not(.li_show_more)',function(e){
		//update the preview within the form
		$("#form_theme_preview label").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#form_theme_preview label").css("font-weight","400");
		$("#form_theme_preview label").css("font-style","normal");
		
		//highlight selected font list
		$(this).siblings().removeClass('font_selected');
		$(this).addClass('font_selected');
		
		//update the font preview box
		$("#et_field_title_font_preview_box").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#et_field_title_font_preview_name").text($(this).children('div.font_picker_preview').text());
		
		//save the data into the theme properties
		theme_properties.field_title_font_type = $(this).find('div.font_name').text();
		
		//reset the font variants to normal
		theme_properties.field_title_font_weight = 400;
		theme_properties.field_title_font_style  = 'normal';
	});
	
	//attach event to the font styles (italic, bold, normal, etc)
	$("#et_ul_typo_field_title_style").on('click',"input[type='radio']",function(e){
		var option_values = $(this).val().split('-');
		
		$("#form_theme_preview label.description").css("font-weight",option_values[0]);
		theme_properties.field_title_font_weight = parseInt(option_values[0]);
		
		if(option_values[1] == 'italic'){
			$("#form_theme_preview label").css("font-style","italic");
			theme_properties.field_title_font_style = 'italic';
		}else{
			$("#form_theme_preview label").css("font-style","normal");
			theme_properties.field_title_font_style = 'normal';
		}
	});
	
	//attach event to the font size boxes.
	$("#et_typo_field_title_size_pickerbox").on('click', 'li', function(e){
		$("#form_theme_preview label.description").css("font-size",$(this).data('fsize'));
		$(this).siblings().removeClass('box_selected');
		$(this).addClass('box_selected');
		
		theme_properties.field_title_font_size = $(this).data('fsize');
		
		adjust_dropui_positions('fonts');
	});
	
	/***************************************************************************************************************/	
	/* 11. Attach events to Field Guidelines Font																   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-typo-guidelines a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-typo-form-title,#dropui-typo-form-desc,#dropui-typo-field-title,#dropui-typo-guidelines,#dropui-typo-section-title,#dropui-typo-section-desc,#dropui-typo-field-text").removeClass('hovered');
		$("#dropui-typo-form-title div.dropui-content,#dropui-typo-form-desc div.dropui-content,#dropui-typo-field-title div.dropui-content," +
		  "#dropui-typo-guidelines div.dropui-content,#dropui-typo-section-title div.dropui-content,#dropui-typo-section-desc div.dropui-content,#dropui-typo-field-text div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//when the first time being displayed, the font picker is being displayed
		//make sure to select the default font in this case
		if(theme_properties.guidelines_font_type == '' || theme_properties.guidelines_font_type == 'Lucida Grande'){
			$("#et_li_typo_guidelines_font_tab li:eq(0)").addClass('font_selected');
		}
		
		//make sure to update the font preview box
		$("#et_guidelines_font_preview_box").css("font-family",theme_properties.guidelines_font_type);
		$("#et_guidelines_font_preview_name").text(theme_properties.guidelines_font_type);
		
		$("#et_typo_guidelines_minicolor_input").miniColors('value', theme_properties.guidelines_font_color);
	});
	
	//attach event to form title font minicolors
	$("#et_typo_guidelines_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#li_fields p.guidelines small").css("color",hex);
			$("#et_typo_guidelines_minicolor_box").css("background-color",hex);
			
			theme_properties.guidelines_font_color = hex;
	
		}
		
	});
	
	//attach events to color boxes
	$("#et_li_typo_guidelines_color_tab").on('click', 'li', function(e) {
		
		$("#et_li_typo_guidelines_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			
			$("#et_typo_guidelines_minicolor_input").miniColors('value','');
			
			$("#li_fields p.guidelines small").css("color","transparent");
			
			$("#et_typo_guidelines_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_typo_guidelines_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.guidelines_font_color = 'transparent';
		}else{
			
			$("#et_typo_guidelines_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_typo_guidelines_minicolor_input").miniColors('value', hex_color);
		}
	});
	
	//attach event to the font tab bar
	$("#et_ul_typo_guidelines").on('click', 'li', function(e) {
		$('#' + $("#et_ul_typo_guidelines li.tab_selected").attr('id') + '_tab').hide();
		$("#et_ul_typo_guidelines li.tab_selected").removeClass('tab_selected');
		
		$(this).addClass('tab_selected');
		
		//resize the tab container based on selection
		var selected_tab_id = $(this).attr('id');
		
		if(selected_tab_id == 'et_li_typo_guidelines_style'){ //shrink to smaller size (font style)
			$("#et_typo_guidelines_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-guidelines div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			//populate the font variants radio button for the selected font type
			var font_slug = theme_properties.guidelines_font_type.replace(/ /g,'').toLowerCase();
			var font_variants = $("#header").data("font_" + font_slug);
			
			//if the font doesn't have variants being set, assume it's a system font and only have 3 variants (normal, italic, bold)
			if(font_variants == null){
				font_variants = {"400":"Normal","400-italic":"Italic","700":"Bold"};
			}
			
			var li_markup = '';
			$.each(font_variants,function(font_variant_numeric,font_variant_label){
				li_markup += '<li><input type="radio" name="et_typo_guidelines_style_radio" id="et_typo_guidelines_style_radio'+ font_variant_numeric +'" value="'+ font_variant_numeric + '" /> <label for="et_typo_guidelines_style_radio'+ font_variant_numeric +'">'+ font_variant_label +'</label></li>';
			});
			
			$("#et_ul_typo_guidelines_style > li").not('.dummy_li').remove();
			$("#et_ul_typo_guidelines_style").append(li_markup);
			
			//select the radio button
			if(theme_properties.guidelines_font_weight == 0){
				theme_properties.guidelines_font_weight = 400; //set to normal as the default
			}
			
			var selected_font_style = theme_properties.guidelines_font_weight;
			if(theme_properties.guidelines_font_style == 'italic'){
				selected_font_style = selected_font_style + "-italic";
			}
			
			$("#et_ul_typo_guidelines_style input[value='"+ selected_font_style +"']").prop("checked",true);
			
		}else if(selected_tab_id == 'et_li_typo_guidelines_size'){ //shrink to smaller size (font size)
			$("#et_typo_guidelines_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-guidelines div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			if(theme_properties.guidelines_font_size == ''){
				theme_properties.guidelines_font_size = '80%'; //the default size for guidelines
			}
			
			//select the box
			$("#et_typo_guidelines_size_pickerbox li[data-fsize='"+ theme_properties.guidelines_font_size +"']").addClass('box_selected');
			
		}else if(selected_tab_id == 'et_li_typo_guidelines_color'){ //shrink to smaller size (font color)
			$("#et_typo_guidelines_content").animate({'width': '305px'},{duration:200,queue:false});
			$("#dropui-typo-guidelines div.dropui-content").animate({'width': '360px'},{duration:200,queue:false });
			
		}else{
			$("#et_typo_guidelines_content").animate({'width': '450px'},{duration:200,queue:false});
			$("#dropui-typo-guidelines div.dropui-content").animate({'width': '507px'},{duration:200,queue:false});
		}
		
		$('#' + selected_tab_id + '_tab').fadeIn(); //display the tab content
		
	});
	
	//attach event to the font type picker list
	$("#et_li_typo_guidelines_font_tab").on('click','li:not(.li_show_more)',function(e){
		//update the preview within the form
		$("#li_fields p.guidelines small").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#li_fields p.guidelines small").css("font-weight","400");
		$("#li_fields p.guidelines small").css("font-style","normal");
		
		//highlight selected font list
		$(this).siblings().removeClass('font_selected');
		$(this).addClass('font_selected');
		
		//update the font preview box
		$("#et_guidelines_font_preview_box").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#et_guidelines_font_preview_name").text($(this).children('div.font_picker_preview').text());
		
		//save the data into the theme properties
		theme_properties.guidelines_font_type = $(this).find('div.font_name').text();
		
		//reset the font variants to normal
		theme_properties.guidelines_font_weight = 400;
		theme_properties.guidelines_font_style  = 'normal';
	});
	
	//attach event to the font styles (italic, bold, normal, etc)
	$("#et_ul_typo_guidelines_style").on('click',"input[type='radio']",function(e){
		var option_values = $(this).val().split('-');
		
		$("#li_fields p.guidelines small").css("font-weight",option_values[0]);
		theme_properties.guidelines_font_weight = parseInt(option_values[0]);
		
		if(option_values[1] == 'italic'){
			$("#li_fields p.guidelines small").css("font-style","italic");
			theme_properties.guidelines_font_style = 'italic';
		}else{
			$("#li_fields p.guidelines small").css("font-style","normal");
			theme_properties.guidelines_font_style = 'normal';
		}
	});
	
	//attach event to the font size boxes.
	$("#et_typo_guidelines_size_pickerbox").on('click', 'li', function(e){
		$("#li_fields p.guidelines small").css("font-size",$(this).data('fsize'));
		$(this).siblings().removeClass('box_selected');
		$(this).addClass('box_selected');
		
		theme_properties.guidelines_font_size = $(this).data('fsize');
		
		adjust_dropui_positions('fonts');
	});
	
	/***************************************************************************************************************/	
	/* 12. Attach events to Section Title Font																	   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-typo-section-title a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-typo-form-title,#dropui-typo-form-desc,#dropui-typo-field-title,#dropui-typo-guidelines,#dropui-typo-section-title,#dropui-typo-section-desc,#dropui-typo-field-text").removeClass('hovered');
		$("#dropui-typo-form-title div.dropui-content,#dropui-typo-form-desc div.dropui-content,#dropui-typo-field-title div.dropui-content," +
		  "#dropui-typo-guidelines div.dropui-content,#dropui-typo-section-title div.dropui-content,#dropui-typo-section-desc div.dropui-content,#dropui-typo-field-text div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//when the first time being displayed, the font picker is being displayed
		//make sure to select the default font in this case
		if(theme_properties.section_title_font_type == '' || theme_properties.section_title_font_type == 'Lucida Grande'){
			$("#et_li_typo_section_title_font_tab li:eq(0)").addClass('font_selected');
		}
		
		//make sure to update the font preview box
		$("#et_section_title_font_preview_box").css("font-family",theme_properties.section_title_font_type);
		$("#et_section_title_font_preview_name").text(theme_properties.section_title_font_type);
		
		$("#et_typo_section_title_minicolor_input").miniColors('value', theme_properties.section_title_font_color);
	});
	
	//attach event to form title font minicolors
	$("#et_typo_section_title_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#section_title_preview").css("color",hex);
			$("#et_typo_section_title_minicolor_box").css("background-color",hex);
			
			theme_properties.section_title_font_color = hex;
	
		}
		
	});
	
	//attach events to color boxes
	$("#et_li_typo_section_title_color_tab").on('click', 'li', function(e) {
		
		$("#et_li_typo_section_title_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			
			$("#et_typo_section_title_minicolor_input").miniColors('value','');
			
			$("#section_title_preview").css("color","transparent");
			
			$("#et_typo_section_title_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_typo_section_title_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.section_title_font_color = 'transparent';
		}else{
			
			$("#et_typo_section_title_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_typo_section_title_minicolor_input").miniColors('value', hex_color);
		}
	});
	
	//attach event to the font tab bar
	$("#et_ul_typo_section_title").on('click', 'li', function(e) {
		$('#' + $("#et_ul_typo_section_title li.tab_selected").attr('id') + '_tab').hide();
		$("#et_ul_typo_section_title li.tab_selected").removeClass('tab_selected');
		
		$(this).addClass('tab_selected');
		
		//resize the tab container based on selection
		var selected_tab_id = $(this).attr('id');
		
		if(selected_tab_id == 'et_li_typo_section_title_style'){ //shrink to smaller size (font style)
			$("#et_typo_section_title_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-section-title div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			//populate the font variants radio button for the selected font type
			var font_slug = theme_properties.section_title_font_type.replace(/ /g,'').toLowerCase();
			var font_variants = $("#header").data("font_" + font_slug);
			
			//if the font doesn't have variants being set, assume it's a system font and only have 3 variants (normal, italic, bold)
			if(font_variants == null){
				font_variants = {"400":"Normal","400-italic":"Italic","700":"Bold"};
			}
			
			var li_markup = '';
			$.each(font_variants,function(font_variant_numeric,font_variant_label){
				li_markup += '<li><input type="radio" name="et_typo_section_title_style_radio" id="et_typo_section_title_style_radio'+ font_variant_numeric +'" value="'+ font_variant_numeric + '" /> <label for="et_typo_section_title_style_radio'+ font_variant_numeric +'">'+ font_variant_label +'</label></li>';
			});
			
			$("#et_ul_typo_section_title_style > li").not('.dummy_li').remove();
			$("#et_ul_typo_section_title_style").append(li_markup);
			
			//select the radio button
			if(theme_properties.section_title_font_weight == 0){
				theme_properties.section_title_font_weight = 400; //set to normal as the default
			}
			
			var selected_font_style = theme_properties.section_title_font_weight;
			if(theme_properties.section_title_font_style == 'italic'){
				selected_font_style = selected_font_style + "-italic";
			}
			
			$("#et_ul_typo_section_title_style input[value='"+ selected_font_style +"']").prop("checked",true);
			
		}else if(selected_tab_id == 'et_li_typo_section_title_size'){ //shrink to smaller size (font size)
			$("#et_typo_section_title_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-section-title div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			if(theme_properties.section_title_font_size == ''){
				theme_properties.section_title_font_size = '110%'; //the default size for section title
			}
			
			//select the box
			$("#et_typo_section_title_size_pickerbox li[data-fsize='"+ theme_properties.section_title_font_size +"']").addClass('box_selected');
			
		}else if(selected_tab_id == 'et_li_typo_section_title_color'){ //shrink to smaller size (font color)
			$("#et_typo_section_title_content").animate({'width': '305px'},{duration:200,queue:false});
			$("#dropui-typo-section-title div.dropui-content").animate({'width': '360px'},{duration:200,queue:false });
			
		}else{
			$("#et_typo_section_title_content").animate({'width': '450px'},{duration:200,queue:false});
			$("#dropui-typo-section-title div.dropui-content").animate({'width': '507px'},{duration:200,queue:false});
		}
		
		$('#' + selected_tab_id + '_tab').fadeIn(); //display the tab content
		
	});
	
	//attach event to the font type picker list
	$("#et_li_typo_section_title_font_tab").on('click','li:not(.li_show_more)',function(e){
		//update the preview within the form
		$("#section_title_preview").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#section_title_preview").css("font-weight","400");
		$("#section_title_preview").css("font-style","normal");
		
		//highlight selected font list
		$(this).siblings().removeClass('font_selected');
		$(this).addClass('font_selected');
		
		//update the font preview box
		$("#et_section_title_font_preview_box").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#et_section_title_font_preview_name").text($(this).children('div.font_picker_preview').text());
		
		//save the data into the theme properties
		theme_properties.section_title_font_type = $(this).find('div.font_name').text();
		
		//reset the font variants to normal
		theme_properties.section_title_font_weight = 400;
		theme_properties.section_title_font_style  = 'normal';
	});
	
	//attach event to the font styles (italic, bold, normal, etc)
	$("#et_ul_typo_section_title_style").on('click',"input[type='radio']",function(e){
		var option_values = $(this).val().split('-');
		
		$("#section_title_preview").css("font-weight",option_values[0]);
		theme_properties.section_title_font_weight = parseInt(option_values[0]);
		
		if(option_values[1] == 'italic'){
			$("#section_title_preview").css("font-style","italic");
			theme_properties.section_title_font_style = 'italic';
		}else{
			$("#section_title_preview").css("font-style","normal");
			theme_properties.section_title_font_style = 'normal';
		}
	});
	
	//attach event to the font size boxes.
	$("#et_typo_section_title_size_pickerbox").on('click', 'li', function(e){
		$("#section_title_preview").css("font-size",$(this).data('fsize'));
		$(this).siblings().removeClass('box_selected');
		$(this).addClass('box_selected');
		
		theme_properties.section_title_font_size = $(this).data('fsize');
		
		adjust_dropui_positions('fonts');
	});
	
	/***************************************************************************************************************/	
	/* 13. Attach events to Section Desc Font																	   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-typo-section-desc a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-typo-form-title,#dropui-typo-form-desc,#dropui-typo-field-title,#dropui-typo-guidelines,#dropui-typo-section-title,#dropui-typo-section-desc,#dropui-typo-field-text").removeClass('hovered');
		$("#dropui-typo-form-title div.dropui-content,#dropui-typo-form-desc div.dropui-content,#dropui-typo-field-title div.dropui-content," +
		  "#dropui-typo-guidelines div.dropui-content,#dropui-typo-section-title div.dropui-content,#dropui-typo-section-desc div.dropui-content,#dropui-typo-field-text div.dropui-content").hide();
		
		$("#container").css("margin-bottom","250px"); //provide enough margin at the bottom, so the screen won't be scrolled over and over
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//when the first time being displayed, the font picker is being displayed
		//make sure to select the default font in this case
		if(theme_properties.section_desc_font_type == '' || theme_properties.section_desc_font_type == 'Lucida Grande'){
			$("#et_li_typo_section_desc_font_tab li:eq(0)").addClass('font_selected');
		}
		
		//make sure to update the font preview box
		$("#et_section_desc_font_preview_box").css("font-family",theme_properties.section_desc_font_type);
		$("#et_section_desc_font_preview_name").text(theme_properties.section_desc_font_type);
		
		$("#et_typo_section_desc_minicolor_input").miniColors('value', theme_properties.section_desc_font_color);
	});
	
	//attach event to form title font minicolors
	$("#et_typo_section_desc_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#section_desc_preview").css("color",hex);
			$("#et_typo_section_desc_minicolor_box").css("background-color",hex);
			
			theme_properties.section_desc_font_color = hex;
	
		}
		
	});
	
	//attach events to color boxes
	$("#et_li_typo_section_desc_color_tab").on('click', 'li', function(e) {
		
		$("#et_li_typo_section_desc_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			
			$("#et_typo_section_desc_minicolor_input").miniColors('value','');
			
			$("#section_desc_preview").css("color","transparent");
			
			$("#et_typo_section_desc_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_typo_section_desc_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.section_desc_font_color = 'transparent';
		}else{
			
			$("#et_typo_section_desc_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_typo_section_desc_minicolor_input").miniColors('value', hex_color);
		}
	});
	
	//attach event to the font tab bar
	$("#et_ul_typo_section_desc").on('click', 'li', function(e) {
		$('#' + $("#et_ul_typo_section_desc li.tab_selected").attr('id') + '_tab').hide();
		$("#et_ul_typo_section_desc li.tab_selected").removeClass('tab_selected');
		
		$(this).addClass('tab_selected');
		
		//resize the tab container based on selection
		var selected_tab_id = $(this).attr('id');
		
		if(selected_tab_id == 'et_li_typo_section_desc_style'){ //shrink to smaller size (font style)
			$("#et_typo_section_desc_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-section-desc div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			//populate the font variants radio button for the selected font type
			var font_slug = theme_properties.section_desc_font_type.replace(/ /g,'').toLowerCase();
			var font_variants = $("#header").data("font_" + font_slug);
			
			//if the font doesn't have variants being set, assume it's a system font and only have 3 variants (normal, italic, bold)
			if(font_variants == null){
				font_variants = {"400":"Normal","400-italic":"Italic","700":"Bold"};
			}
			
			var li_markup = '';
			$.each(font_variants,function(font_variant_numeric,font_variant_label){
				li_markup += '<li><input type="radio" name="et_typo_section_desc_style_radio" id="et_typo_section_desc_style_radio'+ font_variant_numeric +'" value="'+ font_variant_numeric + '" /> <label for="et_typo_section_desc_style_radio'+ font_variant_numeric +'">'+ font_variant_label +'</label></li>';
			});
			
			$("#et_ul_typo_section_desc_style > li").not('.dummy_li').remove();
			$("#et_ul_typo_section_desc_style").append(li_markup);
			
			//select the radio button
			if(theme_properties.section_desc_font_weight == 0){
				theme_properties.section_desc_font_weight = 400; //set to normal as the default
			}
			
			var selected_font_style = theme_properties.section_desc_font_weight;
			if(theme_properties.section_desc_font_style == 'italic'){
				selected_font_style = selected_font_style + "-italic";
			}
			
			$("#et_ul_typo_section_desc_style input[value='"+ selected_font_style +"']").prop("checked",true);
			
		}else if(selected_tab_id == 'et_li_typo_section_desc_size'){ //shrink to smaller size (font size)
			$("#et_typo_section_desc_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-section-desc div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			if(theme_properties.section_desc_font_size == ''){
				theme_properties.section_desc_font_size = '85%'; //the default size for section title
			}
			
			//select the box
			$("#et_typo_section_desc_size_pickerbox li[data-fsize='"+ theme_properties.section_desc_font_size +"']").addClass('box_selected');
			
		}else if(selected_tab_id == 'et_li_typo_section_desc_color'){ //shrink to smaller size (font color)
			$("#et_typo_section_desc_content").animate({'width': '305px'},{duration:200,queue:false});
			$("#dropui-typo-section-desc div.dropui-content").animate({'width': '360px'},{duration:200,queue:false });
			
		}else{
			$("#et_typo_section_desc_content").animate({'width': '450px'},{duration:200,queue:false});
			$("#dropui-typo-section-desc div.dropui-content").animate({'width': '507px'},{duration:200,queue:false});
		}
		
		$('#' + selected_tab_id + '_tab').fadeIn(); //display the tab content
		
	});
	
	//attach event to the font type picker list
	$("#et_li_typo_section_desc_font_tab").on('click','li:not(.li_show_more)',function(e){
		//update the preview within the form
		$("#section_desc_preview").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#section_desc_preview").css("font-weight","400");
		$("#section_desc_preview").css("font-style","normal");
		
		//highlight selected font list
		$(this).siblings().removeClass('font_selected');
		$(this).addClass('font_selected');
		
		//update the font preview box
		$("#et_section_desc_font_preview_box").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#et_section_desc_font_preview_name").text($(this).children('div.font_picker_preview').text());
		
		//save the data into the theme properties
		theme_properties.section_desc_font_type = $(this).find('div.font_name').text();
		
		//reset the font variants to normal
		theme_properties.section_desc_font_weight = 400;
		theme_properties.section_desc_font_style  = 'normal';
	});
	
	//attach event to the font styles (italic, bold, normal, etc)
	$("#et_ul_typo_section_desc_style").on('click',"input[type='radio']",function(e){
		var option_values = $(this).val().split('-');
		
		$("#section_desc_preview").css("font-weight",option_values[0]);
		theme_properties.section_desc_font_weight = parseInt(option_values[0]);
		
		if(option_values[1] == 'italic'){
			$("#section_desc_preview").css("font-style","italic");
			theme_properties.section_desc_font_style = 'italic';
		}else{
			$("#section_desc_preview").css("font-style","normal");
			theme_properties.section_desc_font_style = 'normal';
		}
	});
	
	//attach event to the font size boxes.
	$("#et_typo_section_desc_size_pickerbox").on('click', 'li', function(e){
		$("#section_desc_preview").css("font-size",$(this).data('fsize'));
		$(this).siblings().removeClass('box_selected');
		$(this).addClass('box_selected');
		
		theme_properties.section_desc_font_size = $(this).data('fsize');
		
		adjust_dropui_positions('fonts');
	});
	
	/***************************************************************************************************************/	
	/* 14. Attach events to Field Text Font																	   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-typo-field-text a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-typo-form-title,#dropui-typo-form-desc,#dropui-typo-field-title,#dropui-typo-guidelines,#dropui-typo-section-title,#dropui-typo-section-desc,#dropui-typo-field-text").removeClass('hovered');
		$("#dropui-typo-form-title div.dropui-content,#dropui-typo-form-desc div.dropui-content,#dropui-typo-field-title div.dropui-content," +
		  "#dropui-typo-guidelines div.dropui-content,#dropui-typo-section-title div.dropui-content,#dropui-typo-section-desc div.dropui-content,#dropui-typo-field-text div.dropui-content").hide();
		
		$("#container").css("margin-bottom","250px"); //provide enough margin at the bottom, so the screen won't be scrolled over and over
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//when the first time being displayed, the font picker is being displayed
		//make sure to select the default font in this case
		if(theme_properties.field_text_font_type == '' || theme_properties.field_text_font_type == 'Lucida Grande'){
			$("#et_li_typo_field_text_font_tab li:eq(0)").addClass('font_selected');
		}
		
		//make sure to update the font preview box
		$("#et_field_text_font_preview_box").css("font-family",theme_properties.field_text_font_type);
		$("#et_field_text_font_preview_name").text(theme_properties.field_text_font_type);
		
		$("#et_typo_field_text_minicolor_input").miniColors('value', theme_properties.field_text_font_color);
	});
	
	//attach event to form title font minicolors
	$("#et_typo_field_text_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#form_theme_preview :input").not(".submit_button").css("color",hex);
			$("#et_typo_field_text_minicolor_box").css("background-color",hex);
			
			theme_properties.field_text_font_color = hex;
	
		}
		
	});
	
	//attach events to color boxes
	$("#et_li_typo_field_text_color_tab").on('click', 'li', function(e) {
		
		$("#et_li_typo_field_text_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			
			$("#et_typo_field_text_minicolor_input").miniColors('value','');
			
			$("#form_theme_preview :input").not(".submit_button").css("color","transparent");
			
			$("#et_typo_field_text_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_typo_field_text_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.field_text_font_color = 'transparent';
		}else{
			
			$("#et_typo_field_text_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_typo_field_text_minicolor_input").miniColors('value', hex_color);
		}
	});
	
	//attach event to the font tab bar
	$("#et_ul_typo_field_text").on('click', 'li', function(e) {
		$('#' + $("#et_ul_typo_field_text li.tab_selected").attr('id') + '_tab').hide();
		$("#et_ul_typo_field_text li.tab_selected").removeClass('tab_selected');
		
		$(this).addClass('tab_selected');
		
		//resize the tab container based on selection
		var selected_tab_id = $(this).attr('id');
		
		if(selected_tab_id == 'et_li_typo_field_text_style'){ //shrink to smaller size (font style)
			$("#et_typo_field_text_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-field-text div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			//populate the font variants radio button for the selected font type
			var font_slug = theme_properties.field_text_font_type.replace(/ /g,'').toLowerCase();
			var font_variants = $("#header").data("font_" + font_slug);
			
			//if the font doesn't have variants being set, assume it's a system font and only have 3 variants (normal, italic, bold)
			if(font_variants == null){
				font_variants = {"400":"Normal","400-italic":"Italic","700":"Bold"};
			}
			
			var li_markup = '';
			$.each(font_variants,function(font_variant_numeric,font_variant_label){
				li_markup += '<li><input type="radio" name="et_typo_field_text_style_radio" id="et_typo_field_text_style_radio'+ font_variant_numeric +'" value="'+ font_variant_numeric + '" /> <label for="et_typo_field_text_style_radio'+ font_variant_numeric +'">'+ font_variant_label +'</label></li>';
			});
			
			$("#et_ul_typo_field_text_style > li").not('.dummy_li').remove();
			$("#et_ul_typo_field_text_style").append(li_markup);
			
			//select the radio button
			if(theme_properties.field_text_font_weight == 0){
				theme_properties.field_text_font_weight = 400; //set to normal as the default
			}
			
			var selected_font_style = theme_properties.field_text_font_weight;
			if(theme_properties.field_text_font_style == 'italic'){
				selected_font_style = selected_font_style + "-italic";
			}
			
			$("#et_ul_typo_field_text_style input[value='"+ selected_font_style +"']").prop("checked",true);
			
		}else if(selected_tab_id == 'et_li_typo_field_text_size'){ //shrink to smaller size (font size)
			$("#et_typo_field_text_content").animate({'width': '295px'},{duration:200,queue:false});
			$("#dropui-typo-field-text div.dropui-content").animate({'width': '350px'},{duration:200,queue:false });
			
			if(theme_properties.field_text_font_size == ''){
				theme_properties.field_text_font_size = '100%'; //the default size for field text
			}
			
			//select the box
			$("#et_typo_field_text_size_pickerbox li[data-fsize='"+ theme_properties.field_text_font_size +"']").addClass('box_selected');
			
		}else if(selected_tab_id == 'et_li_typo_field_text_color'){ //shrink to smaller size (font color)
			$("#et_typo_field_text_content").animate({'width': '305px'},{duration:200,queue:false});
			$("#dropui-typo-field-text div.dropui-content").animate({'width': '360px'},{duration:200,queue:false });
			
		}else{
			$("#et_typo_field_text_content").animate({'width': '450px'},{duration:200,queue:false});
			$("#dropui-typo-field-text div.dropui-content").animate({'width': '507px'},{duration:200,queue:false});
		}
		
		$('#' + selected_tab_id + '_tab').fadeIn(); //display the tab content
		
	});
	
	//attach event to the font type picker list
	$("#et_li_typo_field_text_font_tab").on('click','li:not(.li_show_more)',function(e){
		//update the preview within the form
		$("#form_theme_preview :input").not(".submit_button").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#form_theme_preview :input").not(".submit_button").css("font-weight","400");
		$("#form_theme_preview :input").not(".submit_button").css("font-style","normal");
		
		//highlight selected font list
		$(this).siblings().removeClass('font_selected');
		$(this).addClass('font_selected');
		
		//update the font preview box
		$("#et_field_text_font_preview_box").css("font-family",$(this).children('div.font_picker_preview').css('font-family'));
		$("#et_field_text_font_preview_name").text($(this).children('div.font_picker_preview').text());
		
		//save the data into the theme properties
		theme_properties.field_text_font_type = $(this).find('div.font_name').text();
		
		//reset the font variants to normal
		theme_properties.field_text_font_weight = 400;
		theme_properties.field_text_font_style  = 'normal';
	});
	
	//attach event to the font styles (italic, bold, normal, etc)
	$("#et_ul_typo_field_text_style").on('click',"input[type='radio']",function(e){
		var option_values = $(this).val().split('-');
		
		$("#form_theme_preview :input").not(".submit_button").css("font-weight",option_values[0]);
		theme_properties.field_text_font_weight = parseInt(option_values[0]);
		
		if(option_values[1] == 'italic'){
			$("#form_theme_preview :input").not(".submit_button").css("font-style","italic");
			theme_properties.field_text_font_style = 'italic';
		}else{
			$("#form_theme_preview :input").not(".submit_button").css("font-style","normal");
			theme_properties.field_text_font_style = 'normal';
		}
	});
	
	//attach event to the font size boxes.
	$("#et_typo_field_text_size_pickerbox").on('click', 'li', function(e){
		$("#form_theme_preview :input").not(".submit_button").css("font-size",$(this).data('fsize'));
		$(this).siblings().removeClass('box_selected');
		$(this).addClass('box_selected');
		
		theme_properties.field_text_font_size = $(this).data('fsize');
		
		adjust_dropui_positions('fonts');
	});
	
	/***************************************************************************************************************/	
	/* 15. Attach events to Form Border																	   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-border-form a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-border-form,#dropui-border-guidelines,#dropui-border-section").removeClass('hovered');
		$("#dropui-border-form div.dropui-content,#dropui-border-guidelines div.dropui-content,#dropui-border-section div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//when the first time being displayed, border thickness is being displayed
		//make sure to load the setting for the thickness
		$("#et_ul_border_form_thickness input[value='"+ theme_properties.border_form_width  +"']").prop("checked",true);
	});
	
	//attach event to the border tab bar
	$("#et_ul_border_form").on('click', 'li', function(e) {
		$('#' + $("#et_ul_border_form li.tab_selected").attr('id') + '_tab').hide();
		$("#et_ul_border_form li.tab_selected").removeClass('tab_selected');
		
		$(this).addClass('tab_selected');
		
		//resize the tab container based on selection
		var selected_tab_id = $(this).attr('id');
		
		if(selected_tab_id == 'et_li_border_form_thickness'){ //border thickness
			$("#et_border_form_content").animate({'width': '215px'},{duration:200,queue:false});
			$("#dropui-border-form div.dropui-content").animate({'width': '270px'},{duration:200,queue:false });
			
			//load the setting for border thickness
			$("#et_ul_border_form_thickness input[value='"+ theme_properties.border_form_width  +"']").prop("checked",true);
		}else if(selected_tab_id == 'et_li_border_form_style'){ //border style
			$("#et_border_form_content").animate({'width': '215px'},{duration:200,queue:false});
			$("#dropui-border-form div.dropui-content").animate({'width': '270px'},{duration:200,queue:false });
			
			//load the setting for border style
			$("#et_ul_border_form_style input[value='"+ theme_properties.border_form_style  +"']").prop("checked",true);
		}else if(selected_tab_id == 'et_li_border_form_color'){ //border color
			$("#et_border_form_content").animate({'width': '305px'},{duration:200,queue:false});
			$("#dropui-border-form div.dropui-content").animate({'width': '360px'},{duration:200,queue:false });
		
			$("#et_border_form_minicolor_input").miniColors('value', theme_properties.border_form_color);
		}
		
		$('#' + selected_tab_id + '_tab').fadeIn(); //display the tab content
		
	});
	
	//attach event to the border thickness radio buttons
	$("#et_ul_border_form_thickness").on('click',"input[type='radio']",function(e){
		$("#form_container").css("border-width",$(this).val() + "px");
		
		theme_properties.border_form_width = parseInt($(this).val());

		if(theme_properties.border_form_width == 0){
			$("#form_container").css("box-shadow","none");
			$("#form_container").css("border-width","0px");
		}else if(theme_properties.border_form_width == 1){
			$("#form_container").css("box-shadow","0 0 3px rgba(0, 0, 0, 0.4)");
			$("#form_container").css("border-width","0px");
		}else{
			$("#form_container").css("box-shadow","0 0 3px rgba(0, 0, 0, 0.4)");
		}
	});
	
	//attach event to the border style radio buttons
	$("#et_ul_border_form_style").on('click',"input[type='radio']",function(e){
		$("#form_container").css("border-style",$(this).val());
		
		theme_properties.border_form_style = $(this).val();
	});
	
	//attach event to form border minicolors
	$("#et_border_form_minicolor_input").miniColors({
		change: function(hex, rgb) {
			
			if(theme_properties.border_form_width == 1){
				if(hex.toLowerCase() == '#cccccc'){
					$("#form_container").css("border-width","0px");
				}else{
					$("#form_container").css("border-width","1px");
				}
			}

			$("#form_container").css("border-color",hex);
			$("#et_border_form_minicolor_box").css("background-color",hex);
			
			theme_properties.border_form_color = hex;
	
		}
		
	});
	
	//attach events to color boxes
	$("#et_li_border_form_color_tab").on('click', 'li', function(e) {
		
		$("#et_li_border_form_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			
			$("#et_border_form_minicolor_input").miniColors('value','');
			
			$("#form_container").css("border-color","transparent");
			
			$("#et_border_form_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_border_form_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.border_form_color = 'transparent';
		}else{
			
			$("#et_border_form_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_border_form_minicolor_input").miniColors('value', hex_color);
		}
	});
	
	/***************************************************************************************************************/	
	/* 15. Attach events to Guidelines Border																	   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-border-guidelines a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-border-form,#dropui-border-guidelines,#dropui-border-section").removeClass('hovered');
		$("#dropui-border-form div.dropui-content,#dropui-border-guidelines div.dropui-content,#dropui-border-section div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//when the first time being displayed, border thickness is being displayed
		//make sure to load the setting for the thickness
		$("#et_ul_border_guidelines_thickness input[value='"+ theme_properties.border_guidelines_width  +"']").prop("checked",true);
	});
	
	//attach event to the border tab bar
	$("#et_ul_border_guidelines").on('click', 'li', function(e) {
		$('#' + $("#et_ul_border_guidelines li.tab_selected").attr('id') + '_tab').hide();
		$("#et_ul_border_guidelines li.tab_selected").removeClass('tab_selected');
		
		$(this).addClass('tab_selected');
		
		//resize the tab container based on selection
		var selected_tab_id = $(this).attr('id');
		
		if(selected_tab_id == 'et_li_border_guidelines_thickness'){ //border thickness
			$("#et_border_guidelines_content").animate({'width': '215px'},{duration:200,queue:false});
			$("#dropui-border-guidelines div.dropui-content").animate({'width': '270px'},{duration:200,queue:false });
			
			//load the setting for border thickness
			$("#et_ul_border_guidelines_thickness input[value='"+ theme_properties.border_guidelines_width  +"']").prop("checked",true);
		}else if(selected_tab_id == 'et_li_border_guidelines_style'){ //border style
			$("#et_border_guidelines_content").animate({'width': '215px'},{duration:200,queue:false});
			$("#dropui-border-guidelines div.dropui-content").animate({'width': '270px'},{duration:200,queue:false });
			
			//load the setting for border style
			$("#et_ul_border_guidelines_style input[value='"+ theme_properties.border_guidelines_style  +"']").prop("checked",true);
		}else if(selected_tab_id == 'et_li_border_guidelines_color'){ //border color
			$("#et_border_guidelines_content").animate({'width': '305px'},{duration:200,queue:false});
			$("#dropui-border-guidelines div.dropui-content").animate({'width': '360px'},{duration:200,queue:false });
		
			$("#et_border_guidelines_minicolor_input").miniColors('value', theme_properties.border_guidelines_color);
		}
		
		$('#' + selected_tab_id + '_tab').fadeIn(); //display the tab content
		
	});
	
	//attach event to the border thickness radio buttons
	$("#et_ul_border_guidelines_thickness").on('click',"input[type='radio']",function(e){
		$("#guide_2").css("border-width",$(this).val() + "px");
		
		theme_properties.border_guidelines_width = parseInt($(this).val());
	});
	
	//attach event to the border style radio buttons
	$("#et_ul_border_guidelines_style").on('click',"input[type='radio']",function(e){
		$("#guide_2").css("border-style",$(this).val());
		
		theme_properties.border_guidelines_style = $(this).val();
	});
	
	//attach event to form border minicolors
	$("#et_border_guidelines_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#guide_2").css("border-color",hex);
			$("#et_border_guidelines_minicolor_box").css("background-color",hex);
			
			theme_properties.border_guidelines_color = hex;
	
		}
		
	});
	
	//attach events to color boxes
	$("#et_li_border_guidelines_color_tab").on('click', 'li', function(e) {
		
		$("#et_li_border_guidelines_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			
			$("#et_border_guidelines_minicolor_input").miniColors('value','');
			
			$("#guide_2").css("border-color","transparent");
			
			$("#et_border_guidelines_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_border_guidelines_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.border_guidelines_color = 'transparent';
		}else{
			
			$("#et_border_guidelines_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_border_guidelines_minicolor_input").miniColors('value', hex_color);
		}
	});
	
	/***************************************************************************************************************/	
	/* 15. Attach events to Section Border																	   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-border-section a.dropui-tab").on('click',function(){
		//hide all other opened dropui within the same tab category
		$("#dropui-border-form,#dropui-border-guidelines,#dropui-border-section").removeClass('hovered');
		$("#dropui-border-form div.dropui-content,#dropui-border-guidelines div.dropui-content,#dropui-border-section div.dropui-content").hide();
		
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//when the first time being displayed, border thickness is being displayed
		//make sure to load the setting for the thickness
		$("#et_ul_border_section_thickness input[value='"+ theme_properties.border_section_width  +"']").prop("checked",true);
	});
	
	//attach event to the border tab bar
	$("#et_ul_border_section").on('click', 'li', function(e) {
		$('#' + $("#et_ul_border_section li.tab_selected").attr('id') + '_tab').hide();
		$("#et_ul_border_section li.tab_selected").removeClass('tab_selected');
		
		$(this).addClass('tab_selected');
		
		//resize the tab container based on selection
		var selected_tab_id = $(this).attr('id');
		
		if(selected_tab_id == 'et_li_border_section_thickness'){ //border thickness
			$("#et_border_section_content").animate({'width': '215px'},{duration:200,queue:false});
			$("#dropui-border-section div.dropui-content").animate({'width': '270px'},{duration:200,queue:false });
			
			//load the setting for border thickness
			$("#et_ul_border_section_thickness input[value='"+ theme_properties.border_section_width  +"']").prop("checked",true);
		}else if(selected_tab_id == 'et_li_border_section_style'){ //border style
			$("#et_border_section_content").animate({'width': '215px'},{duration:200,queue:false});
			$("#dropui-border-section div.dropui-content").animate({'width': '270px'},{duration:200,queue:false });
			
			//load the setting for border style
			$("#et_ul_border_section_style input[value='"+ theme_properties.border_section_style  +"']").prop("checked",true);
		}else if(selected_tab_id == 'et_li_border_section_color'){ //border color
			$("#et_border_section_content").animate({'width': '305px'},{duration:200,queue:false});
			$("#dropui-border-section div.dropui-content").animate({'width': '360px'},{duration:200,queue:false });
		
			$("#et_border_section_minicolor_input").miniColors('value', theme_properties.border_section_color);
		}
		
		$('#' + selected_tab_id + '_tab').fadeIn(); //display the tab content
		
	});
	
	//attach event to the border thickness radio buttons
	$("#et_ul_border_section_thickness").on('click',"input[type='radio']",function(e){
		$("#li_4").css("border-top-width",$(this).val() + "px");
		
		theme_properties.border_section_width = parseInt($(this).val());
	});
	
	//attach event to the border style radio buttons
	$("#et_ul_border_section_style").on('click',"input[type='radio']",function(e){
		$("#li_4").css("border-top-style",$(this).val());
		
		theme_properties.border_section_style = $(this).val();
	});
	
	//attach event to form border minicolors
	$("#et_border_section_minicolor_input").miniColors({
		change: function(hex, rgb) {
		
			$("#li_4").css("border-top-color",hex);
			$("#et_border_section_minicolor_box").css("background-color",hex);
			
			theme_properties.border_section_color = hex;
	
		}
		
	});
	
	//attach events to color boxes
	$("#et_li_border_section_color_tab").on('click', 'li', function(e) {
		
		$("#et_li_border_section_color_tab li.picker_selected").removeClass('picker_selected');
		$(this).addClass('picker_selected');
		
		if($(this).attr("id") == 'li_transparent'){
			
			$("#et_border_section_minicolor_input").miniColors('value','');
			
			$("#li_4").css("border-top-color","transparent");
			
			$("#et_border_section_minicolor_box").css("background-image","url('images/icons/transparent.png')");
			$("#et_border_section_minicolor_box").css("background-repeat","repeat");
			
			theme_properties.border_section_color = 'transparent';
		}else{
			
			$("#et_border_section_minicolor_box").css("background-image","");
			
			var hex_color = rgb2hex($(this).css("background-color"));
			$("#et_border_section_minicolor_input").miniColors('value', hex_color);
		}
	});
	
	/***************************************************************************************************************/	
	/* 16. Attach events to Form Shadow																			   */
	/***************************************************************************************************************/
	
	//display dropui permanently on hover and load the properties
	$("#dropui-form-shadow a.dropui-tab").on('click',function(){
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		$("#container").css("margin-bottom","250px"); //provide enough margin at the bottom, so the screen won't be scrolled over and over
		
		
		//when the first time being displayed, shadow style is being displayed
		//make sure to load the setting for the style
		$("#et_ul_form_shadow_style input[value='"+ theme_properties.form_shadow_style  +"']").prop("checked",true);
		
	});
	
	//attach event to the shadow tab bar
	$("#et_ul_form_shadow").on('click', 'li', function(e) {
		$('#' + $("#et_ul_form_shadow li.tab_selected").attr('id') + '_tab').hide();
		$("#et_ul_form_shadow li.tab_selected").removeClass('tab_selected');
		
		$(this).addClass('tab_selected');
		
		//resize the tab container based on selection
		var selected_tab_id = $(this).attr('id');
		
		if(selected_tab_id == 'et_li_form_shadow_style'){ //shadow style
			$("#et_form_shadow_content").animate({'width': '305px'},{duration:200,queue:false});
			$("#dropui-form-shadow div.dropui-content").animate({'width': '360px'},{duration:200,queue:false });
			
			//load the setting for shadow style
			$("#et_ul_form_shadow_style input[value='"+ theme_properties.form_shadow_style  +"']").prop("checked",true);
		}else if(selected_tab_id == 'et_li_form_shadow_size'){ //shadow size
			$("#et_form_shadow_content").animate({'width': '215px'},{duration:200,queue:false});
			$("#dropui-form-shadow div.dropui-content").animate({'width': '270px'},{duration:200,queue:false });
			
			//load the setting for shadow size
			$("#et_ul_form_shadow_size input[value='"+ theme_properties.form_shadow_size  +"']").prop("checked",true);
		}else if(selected_tab_id == 'et_li_form_shadow_brightness'){ //shadow brightness
			$("#et_form_shadow_content").animate({'width': '215px'},{duration:200,queue:false});
			$("#dropui-form-shadow div.dropui-content").animate({'width': '270px'},{duration:200,queue:false });
			
			//load the setting for shadow brightness
			$("#et_ul_form_shadow_brightness input[value='"+ theme_properties.form_shadow_brightness  +"']").prop("checked",true);
		}
		
		$('#' + selected_tab_id + '_tab').fadeIn(); //display the tab content
		
	});
	
	//attach event to shadow style radio buttons
	$("#et_ul_form_shadow_style").on('click',"input[type='radio']",function(e){
		var shadow_style = $(this).val();
		
		$("#form_container").removeClass(); //remove all existing class
		
		if(shadow_style != 'disabled'){
			//this regex simply get the capital characters of the shadow style name
			//example: RightPerspectiveShadow result to RPS and then being sliced to RP
			var prefix_code = shadow_style.match(/[A-Z]/g).join('').slice(0,-1);
			
			//determine shadow size class name
			var shadow_size_class = prefix_code + ucfirst(theme_properties.form_shadow_size);
			
			//determine shadow brightness class name
			var shadow_brightness_class = prefix_code + ucfirst(theme_properties.form_shadow_brightness);
			
			//set the new shadow style class
			$("#form_container").addClass(shadow_style + " " + shadow_size_class + " " + shadow_brightness_class);
		}
		
		theme_properties.form_shadow_style = shadow_style;
	});
	
	//attach event to shadow size radio buttons
	$("#et_ul_form_shadow_size").on('click',"input[type='radio']",function(e){
		//this regex simply get the capital characters of the shadow style name
		//example: RightPerspectiveShadow result to RPS and then being sliced to RP
		var prefix_code = theme_properties.form_shadow_style.match(/[A-Z]/g).join('').slice(0,-1);
		
		//remove all previous size first
		$("#form_container").removeClass(prefix_code + "Small " + prefix_code + "Medium " + prefix_code + "Large");
		
		//set the new size
		$("#form_container").addClass(prefix_code + ucfirst($(this).val()));
		
		theme_properties.form_shadow_size = $(this).val();
	});
	
	//attach event to shadow brightness radio buttons
	$("#et_ul_form_shadow_brightness").on('click',"input[type='radio']",function(e){
		//this regex simply get the capital characters of the shadow style name
		//example: RightPerspectiveShadow result to RPS and then being sliced to RP
		var prefix_code = theme_properties.form_shadow_style.match(/[A-Z]/g).join('').slice(0,-1);
		
		//remove all previous brightness first
		$("#form_container").removeClass(prefix_code + "Light " + prefix_code + "Normal " + prefix_code + "Dark");
		
		//set the new size
		$("#form_container").addClass(prefix_code + ucfirst($(this).val()));
		
		theme_properties.form_shadow_brightness = $(this).val();
	});
	
	/***************************************************************************************************************/	
	/* 16. Attach events to Form Button																			   */
	/***************************************************************************************************************/
	
	//display dropui permanently on click and load the properties
	$("#dropui-form-button a.dropui-tab").on('click',function(){
		$(this).parent().addClass('hovered');
		$(this).next().show(); //display the properties container
		
		//unselect all tabs and hide all contents
		$("#et_ul_form_button li.prop_selected").removeClass('prop_selected');
		$("#et_form_button_content > div").hide();
			
		//populate the settings for the buttons
		if(theme_properties.form_button_image == ''){
			theme_properties.form_button_image = 'http://';
		}
		
		$("#et_form_button_text_input").val(theme_properties.form_button_text);
		$("#et_form_button_image_input").val(theme_properties.form_button_image);
		
		$("#submit_form").val(theme_properties.form_button_text);
		$("#submit_form_image").attr("src",theme_properties.form_button_image);
		
		//display the selected logo type tab
		if(theme_properties.form_button_type == 'text'){ 
			$("#et_form_button_text").parent().addClass('prop_selected');
			$("#et_form_button_text").prop("checked",true);
				
			$("#et_form_button_text_tab").show();
		}else if(theme_properties.form_button_type == 'image'){
			$("#et_form_button_image").parent().addClass('prop_selected');
			$("#et_form_button_image").prop("checked",true);
				
			$("#et_form_button_image_tab").show();
		}
				
	});
	
	//assign click event for the radio button on the vertical tab bar
	//show/hide the selected tab based on the radio button clicked
	$("#et_ul_form_button input[type=radio]").on('click',function(){
		$('#' + $("#et_ul_form_button li.prop_selected input").attr('id') + '_tab').hide();
		$("#et_ul_form_button li.prop_selected").removeClass('prop_selected');
		
		$(this).parent().addClass('prop_selected');
		$('#' + $(this).attr('id') + '_tab').fadeIn(); //display the tab content
		
		var selected_radio_id = $(this).attr('id');
		
		if(selected_radio_id == 'et_form_button_text'){ //'button text' radio selected
			theme_properties.form_button_type = 'text';
			
			//display the button
			$("#submit_form_image").hide();
			$("#submit_form").show();
		}else if(selected_radio_id == 'et_form_button_image'){
			theme_properties.form_button_type = 'image';
			
			//display the button
			$("#submit_form").hide();
			$("#submit_form_image").show();
		}
	});
	
	//attach event handle to submit button text input
	$('#et_form_button_text_input').on('keyup mouseout change', function() {
		$("#submit_form").val($(this).val());
		theme_properties.form_button_text = $(this).val();
	});
	
	//attach event handle to submit button image input
	$('#et_form_button_image_input').on('keyup mouseout change', function() {
		$("#submit_form_image").attr("src",$(this).val());
		theme_properties.form_button_image = $(this).val();
	});
	
	
	/***************************************************************************************************************/	
	/* 18. Attach event to 'Save Theme' button																	   */
	/***************************************************************************************************************/
	$("#button_save_theme").on('click',function(){
		if(theme_properties.theme_id == 0){
			//this is a new theme, prompt for the name and then save the theme
			Swal.fire({
				title: 'Name this theme',
				width: '30%',
				input: 'text',
				customClass: {
					htmlContainer: 'swal2-html-container-bold',
					title: 'swal2-title-warning',
					input: 'swal2-text-center'
				},
				showCancelButton: true,
				confirmButtonText: '<span class="icon-disk"></span> Save Theme',
				showLoaderOnConfirm: true,
				preConfirm: (theme_name) => {
					if(theme_name == ''){
						Swal.showValidationMessage('Error: Please enter a name for your theme!');
						return false;
					}
					
					theme_properties.theme_name = theme_name;
					var csrf_token  = $("#content").data("csrftoken");
	
					return axios.post('save_theme.php', {
						csrf_token: csrf_token,
						tp: theme_properties
					})
					.then(function (response) {
						if(response.data.status == 'ok'){
							theme_properties.theme_id = response.data.theme_id;

							//display the confirmation message
							Swal.fire({
								position: 'center',
								icon: 'success',
								title: 'Your theme has been saved.',
								showConfirmButton: true,
								confirmButtonText: "OK",
								allowOutsideClick: true,
								didDestroy: () => {
									//reload the edit theme page with the new theme_id
			   						window.location.replace('edit_theme.php?theme_id=' + theme_properties.theme_id);
								}
							});
						}else{
							Swal.showValidationMessage('Error: Unable to process. Please try again later.');
						}
					})
					.catch(function (error) {
						Swal.showValidationMessage("Error: " + error);
					});
				},
				allowOutsideClick: () => !Swal.isLoading()
			});
		}else{
			if($("#button_save_theme").text() != 'Saving...'){
				//display loader while saving
				$("#button_save_theme").prop("disabled",true);
				$("#button_save_theme").text('Saving...');
				$("#button_save_theme").after("<div class='small_loader_box' style='float: right'><img src='images/loader_small_grey.gif' /></div>");

				var csrf_token  = $("#content").data("csrftoken");
		
				return axios.post('save_theme.php', {
					csrf_token: csrf_token,
					tp: theme_properties
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						theme_properties.theme_id = response.data.theme_id;

						$("#button_save_theme").html('<span class="icon-disk" style="margin-right: 5px"></span>Save Theme');
						$(".small_loader_box").remove();

						//display the confirmation message
						Swal.fire({
							position: 'center',
							icon: 'success',
							title: 'Your theme has been saved.',
							showConfirmButton: true,
							confirmButtonText: "OK",
							allowOutsideClick: true,
							didDestroy: () => {
								//reload the edit theme page with the new theme_id
								window.location.replace('edit_theme.php?theme_id=' + theme_properties.theme_id);
							}
						});
					}else{
						Swal.showValidationMessage('Error: Unable to process. Please try again later.');
					}
				})
				.catch(function (error) {
					Swal.showValidationMessage("Error: " + error);
				});
			}
		}
		
		return false;
	});
		
	/***************************************************************************************************************/	
	/* 19. Attach event to 'Advanced CSS' link 																	   */
	/***************************************************************************************************************/
	$("#advanced_css_link").on('click',function(){
		
		Swal.fire({
			title: 'Input CSS code below to modify form theme:',
			footer: "The CSS result won't appear in the theme editor. Check the form to see the changes.",
			width: '45%',
			input: 'textarea',
			inputValue: theme_properties.advanced_css,
			customClass: {
				htmlContainer: 'swal2-html-container-bold',
				title: 'swal2-title-warning',
				input: 'swal2-text-css-code'
			},
			showCancelButton: true,
			confirmButtonText: '<span class="icon-disk"></span> Save Changes',
			showLoaderOnConfirm: true,
			preConfirm: (advanced_css) => {			
				theme_properties.advanced_css = advanced_css;

				var csrf_token  = $("#content").data("csrftoken");

				return axios.post('save_theme.php', {
					csrf_token: csrf_token,
					tp: theme_properties
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						theme_properties.theme_id = response.data.theme_id;

						//display the confirmation message
						Swal.fire({
							position: 'center',
							icon: 'success',
							title: 'Your theme has been saved.',
							showConfirmButton: true,
							confirmButtonText: "OK",
							allowOutsideClick: true,
							didDestroy: () => {
								//reload the edit theme page with the new theme_id
								window.location.replace('edit_theme.php?theme_id=' + theme_properties.theme_id);
							}
						});
					}else{
						Swal.showValidationMessage('Error: Unable to process. Please try again later.');
					}
				})
				.catch(function (error) {
					Swal.showValidationMessage("Error: " + error);
				});
			},
			allowOutsideClick: () => !Swal.isLoading()
		});

		return false;
	});
	
	/***************************************************************************************************************/	
	/* 20. Attach event to 'Duplicate' link 																	   */
	/***************************************************************************************************************/
	$("#duplicate_theme_link").on('click',function(){

		Swal.fire({
			title: 'Name the new theme',
			width: '30%',
			input: 'text',
			inputValue: theme_properties.theme_name + ' Copy',
			customClass: {
				htmlContainer: 'swal2-html-container-bold',
				title: 'swal2-title-warning',
				input: 'swal2-text-center'
			},
			showCancelButton: true,
			confirmButtonText: '<span class="icon-disk"></span> Save As Copy',
			showLoaderOnConfirm: true,
			preConfirm: (theme_name) => {
				if(theme_name == ''){
					Swal.showValidationMessage('Error: Please enter a name for the new theme!');
					return false;
				}
				
				theme_properties.theme_name = theme_name;
				theme_properties.theme_id = 0;

				var csrf_token  = $("#content").data("csrftoken");

				return axios.post('save_theme.php', {
					csrf_token: csrf_token,
					tp: theme_properties
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						theme_properties.theme_id = response.data.theme_id;

						//display the confirmation message
						Swal.fire({
							position: 'center',
							icon: 'success',
							title: 'Your theme has been saved.',
							showConfirmButton: true,
							confirmButtonText: "OK",
							allowOutsideClick: true,
							didDestroy: () => {
								//reload the edit theme page with the new theme_id
								   window.location.replace('edit_theme.php?theme_id=' + theme_properties.theme_id);
							}
						});
					}else{
						Swal.showValidationMessage('Error: Unable to process. Please try again later.');
					}
				})
				.catch(function (error) {
					Swal.showValidationMessage("Error: " + error);;
				});
			},
			allowOutsideClick: () => !Swal.isLoading()
		});

		return false;
	});
	
	/***************************************************************************************************************/	
	/* 21. Attach event to 'Rename' link 																	   */
	/***************************************************************************************************************/
	$("#rename_theme_link").on('click',function(){
		
		Swal.fire({
			title: 'Enter a New Name',
			width: '30%',
			input: 'text',
			inputValue: theme_properties.theme_name,
			customClass: {
				htmlContainer: 'swal2-html-container-bold',
				title: 'swal2-title-warning',
				input: 'swal2-text-center'
			},
			showCancelButton: true,
			confirmButtonText: '<span class="icon-disk"></span> Rename Theme',
			showLoaderOnConfirm: true,
			preConfirm: (theme_name) => {
				if(theme_name == ''){
					Swal.showValidationMessage('Error: Please enter a name!');
					return false;
				}
				
				theme_properties.theme_name = theme_name;

				var csrf_token  = $("#content").data("csrftoken");

				return axios.post('save_theme.php', {
					csrf_token: csrf_token,
					tp: theme_properties
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						theme_properties.theme_id = response.data.theme_id;

						//display the confirmation message
						Swal.fire({
							position: 'center',
							icon: 'success',
							title: 'Your theme has been saved.',
							showConfirmButton: true,
							confirmButtonText: "OK",
							allowOutsideClick: true,
							didDestroy: () => {
								//reload the edit theme page with the new theme_id
								window.location.replace('edit_theme.php?theme_id=' + theme_properties.theme_id);
							}
						});
					}else{
						Swal.showValidationMessage('Error: Unable to process. Please try again later.');
					}
				})
				.catch(function (error) {
					Swal.showValidationMessage("Error: " + error);;
				});
			},
			allowOutsideClick: () => !Swal.isLoading()
		});

		return false;
	});
	
	//if the user submit the form by hitting the enter key, make sure to call the button_save_theme handler
	$("#dialog-rename-theme-form").on("submit",function(){
		$("#dialog-rename-theme-btn-save").trigger("click");
		return false;
	});
	
	/***************************************************************************************************************/	
	/* 22. Attach event to 'Delete' link 																	   */
	/***************************************************************************************************************/
	$("#delete_theme_link").on('click',function(){
		
		Swal.fire({
			title: 'Are you sure you want to delete this theme?',
			html: 'Any form using this theme will be reverted to the default theme.',
			footer: 'This action cannot be undone.',
			icon: 'warning',
			width: '40%',
			customClass: {
				htmlContainer: 'swal2-html-container-bold swal2-html-container-padding-bottom',
				footer: 'swal2-footer-warning',
				title: 'swal2-title-warning'
			},
			showCancelButton: true,
			confirmButtonText: 'Yes. Delete this theme.',
			showLoaderOnConfirm: true,
			preConfirm: () => {
				theme_properties.status = 0;
				var csrf_token  = $("#content").data("csrftoken");

				return axios.post('save_theme.php', {
					tp: theme_properties,
					csrf_token: csrf_token
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						return response;
					}else{
						Swal.showValidationMessage('Error: Unable to process. Please try again later.');
					}
				})
				.catch(function (error) {
					Swal.showValidationMessage("Error: " + error);
				})
			},
			allowOutsideClick: () => !Swal.isLoading()
		}).then((result) => {
			if(result.isConfirmed) {
				//redirect to a blank theme page
				window.location.replace('edit_theme.php');
			}
		});

		return false;
	});
	
	/***************************************************************************************************************/	
	/* 23. Attach event to Built-in Themes links 																   */
	/***************************************************************************************************************/
	
	$("#ul_builtin_themes").on('click', 'li > a', function(e) {
		//replace the existing theme property with the new selected theme and reload the theme preview
		var new_theme_properties = $(this).parent().data('theme_builtin_properties');
		new_theme_properties.theme_id = 0; 
		
		//we need to overwrite the dom data and the theme_properties variable which refer to the dom data
		$("#et_theme_preview").data("theme_properties",new_theme_properties);
		theme_properties = new_theme_properties;
		
		//append the font link for the new theme to the head tag
		if($(this).parent().data('font_link_loaded') !== 1){
			$("head").append($(this).parent().data('font_link'));
			$(this).parent().data('font_link_loaded',1);
		}
		
		reload_theme();
		
		return false;
	});

	/***************************************************************************************************************/	
	/* 24. Attach event to 'Share Theme' link 																	   */
	/***************************************************************************************************************/
	$("#set_public_theme_link").on('click',function(){
		
		Swal.fire({
			title: 'Are you sure you want to share this theme?',
			html: "Other users can apply this theme to their forms, <br/>but they won't be able to edit it – only use it as is.",
			icon: 'warning',
			width: '40%',
			customClass: {
				htmlContainer: 'swal2-html-container-bold swal2-html-container-padding-bottom',
				title: 'swal2-title-warning'
			},
			showCancelButton: true,
			confirmButtonText: '<span class="icon-disk"></span> Save and Share this theme',
			showLoaderOnConfirm: true,
			preConfirm: () => {
				theme_properties.theme_is_private = 0;
				var csrf_token  = $("#content").data("csrftoken");

				return axios.post('save_theme.php', {
					tp: theme_properties,
					csrf_token: csrf_token
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						return response;
					}else{
						Swal.showValidationMessage('Error: Unable to process. Please try again later.');
					}
				})
				.catch(function (error) {
					Swal.showValidationMessage("Error: " + error);
				})
			},
			allowOutsideClick: () => !Swal.isLoading()
		}).then((result) => {
			if(result.isConfirmed) {
				window.location.replace('edit_theme.php?theme_id=' + theme_properties.theme_id);
			}
		});

		return false;
	});

	/***************************************************************************************************************/	
	/* 25. Attach event to 'Un-Share Theme' link 																   */
	/***************************************************************************************************************/
	$("#set_private_theme_link").on('click',function(){
		
		Swal.fire({
			title: 'Are you sure you want to set this theme private?',
			html: "This action may impact multiple forms. <br/>Any form utilizing this theme will revert to the default theme.",
			footer: 'This action cannot be undone.',
			icon: 'warning',
			width: '40%',
			customClass: {
				htmlContainer: 'swal2-html-container-bold swal2-html-container-padding-bottom',
				title: 'swal2-title-warning',
				footer: 'swal2-footer-warning'
			},
			showCancelButton: true,
			confirmButtonText: '<span class="icon-disk"></span> Save and Set as Private',
			showLoaderOnConfirm: true,
			preConfirm: () => {
				theme_properties.theme_is_private = 1;
				var csrf_token  = $("#content").data("csrftoken");

				return axios.post('save_theme.php', {
					tp: theme_properties,
					csrf_token: csrf_token
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						return response;
					}else{
						Swal.showValidationMessage('Error: Unable to process. Please try again later.');
					}
				})
				.catch(function (error) {
					Swal.showValidationMessage("Error: " + error);
				})
			},
			allowOutsideClick: () => !Swal.isLoading()
		}).then((result) => {
			if(result.isConfirmed) {
				window.location.replace('edit_theme.php?theme_id=' + theme_properties.theme_id);
			}
		});

		return false;
	});

	/***************************************************************************************************************/	
	/* 26. Initialize file uploader for logo and backgrounds 													   */
	/***************************************************************************************************************/
	if(is_support_html5_uploader()){
		$('#et_form_logo_file,#et_wallpaper_custom_bg_file,#et_headerbg_custom_bg_file,#et_form_formbg_custom_file,#et_form_highlightbg_custom_file,#et_form_guidelinesbg_custom_file,#et_form_fieldbg_custom_file').uploadifive({
			'uploadScript'     	: 'upload_theme_images.php',
			'buttonText'        : 'Select File',
			'removeCompleted' 	: true,
			'formData'         	 : {
									 'session_id': $("#et_theme_preview").data("session_id"),
		   				 			 'uploader_origin': ''
				                  },
			'auto'        : true,
		   	'multi'       : false,
		   	'onUploadError' : function(file, errorCode, errorMsg, errorString) {
            						alert('The file ' + file.name + ' could not be uploaded: ' + errorString);
        					   },
        	'onAddQueueItem' : function(file) {
        		var target_uploader = $(this).attr("id");
		   		$(this).data("uploadifive").settings.formData = {'session_id': $("#et_theme_preview").data("session_id"),'uploader_origin': target_uploader };  
        	},
        	'onUploadComplete' : function(file, response) {
        		var is_valid_response = false;
				try{
					var response_json = JSON.parse(response);
					is_valid_response = true;
				}catch(e){
					is_valid_response = false;
					alert(response);
				}
				

				if(is_valid_response == true && response_json.status == "ok"){
					var theme_properties  = $("#et_theme_preview").data("theme_properties");

					if(response_json.uploader_origin == 'et_form_logo_file'){
						//if this is uploader for form logo

						//get the uploaded URL into the URL textbox
						$("#et_your_logo_url").val(response_json.image_url);
						

						//get the height, if any
						if(response_json.image_height > 0){
							$("#et_your_logo_height").val(response_json.image_height);
						}

						//update the preview
						$("#et_your_logo_submit").trigger("click");
					}else if(response_json.uploader_origin == 'et_wallpaper_custom_bg_file'){
						//this is uploader for Wallpaper background

						//get the uploaded URL into the URL textbox
						$("#et_wallpaper_custom_bg").val(response_json.image_url);
						
						//update the preview
						$("#et_wallpaper_custom_bg_submit").trigger("click");
					}else if(response_json.uploader_origin == 'et_headerbg_custom_bg_file'){
						//this is uploader for Header Background

						//get the uploaded URL into the URL textbox
						$("#et_headerbg_custom_bg").val(response_json.image_url);

						//update the preview
						$("#et_headerbg_custom_bg_submit").trigger("click");
					}else if(response_json.uploader_origin == 'et_form_formbg_custom_file'){
						//this is uploader for Form Background

						//get the uploaded URL into the URL textbox
						$("#et_formbg_custom_bg").val(response_json.image_url);
						
						//update the preview
						$("#et_formbg_custom_bg_submit").trigger("click");
					}else if(response_json.uploader_origin == 'et_form_highlightbg_custom_file'){
						//this is uploader for highlight color

						//get the uploaded URL into the URL textbox
						$("#et_highlightbg_custom_bg").val(response_json.image_url);
						
						//update the preview
						$("#et_highlightbg_custom_bg_submit").trigger("click");
					}else if(response_json.uploader_origin == 'et_form_guidelinesbg_custom_file'){
						//this is uploader for Guidelines background

						//get the uploaded URL into the URL textbox
						$("#et_guidelinesbg_custom_bg").val(response_json.image_url);

						//update the preview
						$("#et_guidelinesbg_custom_bg_submit").trigger("click");
					}else if(response_json.uploader_origin == 'et_form_fieldbg_custom_file'){
						//this is uploader for Field Background

						//get the uploaded URL into the URL textbox
						$("#et_fieldbg_custom_bg").val(response_json.image_url);

						//update the preview
						$("#et_fieldbg_custom_bg_submit").trigger("click");
					}


		       	}else{
			       	alert('Error uploading image. Please try again.');
				}  
        	} 

		});
	}

	//Attach event to "more options" link 
	$("#et_form_logo_more,#et_wallpaper_custom_bg_more,#et_headerbg_custom_bg_more,#et_form_formbg_custom_more,#et_form_highlightbg_custom_more,#et_form_guidelinesbg_custom_more,#et_form_fieldbg_custom_more").on('click',function(){
		if($(this).text() == 'more options'){
			//expand more options
			$(this).parent().prev().slideDown();
			$(this).text('hide options');
			
		}else{
			$(this).parent().prev().slideUp();
			$(this).text('more options');
		}
 
		return false;
	});

	$("#theme_editor_loading").fadeOut();
	
});
